/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring.copy;

import java.util.Optional;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fordiac.ide.model.IdentifierVerifier;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.typemanagement.refactoring.RefactoringUtil;
import org.eclipse.fordiac.ide.typemanagement.refactoring.copy.CopyTypeChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.CopyParticipant;

public class CopyTypeParticipant
extends CopyParticipant {
    private IResource resource;
    private IContainer destination;

    protected boolean initialize(Object element) {
        if (element instanceof IResource) {
            IResource res = (IResource)element;
            Object object = this.getArguments().getDestination();
            if (object instanceof IContainer) {
                IContainer dest = (IContainer)object;
                this.resource = res;
                this.destination = dest;
                return RefactoringUtil.containsTypeEntryFile(res);
            }
        }
        return false;
    }

    public String getName() {
        return Messages.CopyTypeChange_RenamePackage;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        String packageNameContainer = PackageNameHelper.getPackageNameFromContainer((IContainer)this.destination);
        Optional errorMessage = IdentifierVerifier.verifyPackageName((String)packageNameContainer);
        if (errorMessage.isPresent()) {
            status.addFatalError((String)errorMessage.get());
        }
        return status;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange change = new CompositeChange(this.getName());
        URI destURI = URI.createPlatformResourceURI((String)this.destination.getFullPath().toString(), (boolean)true);
        try {
            this.addElement(change, this.resource, destURI);
        }
        catch (CoreException e) {
            return null;
        }
        return change;
    }

    private void addElement(CompositeChange change, IResource resource, URI destination) throws CoreException {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            if (TypeLibraryManager.INSTANCE.getTypeEntryForFile(file) != null) {
                change.add((Change)new CopyTypeChange(destination.appendSegment(file.getName())));
            }
        } else if (resource instanceof IContainer) {
            IContainer container = (IContainer)resource;
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                this.addElement(change, member, destination.appendSegment(container.getName()));
                ++n2;
            }
        }
    }
}

