/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring;

import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class UpdateTypeEntryChange
extends Change {
    protected final IFile file;
    protected final TypeEntry typeEntry;
    protected final String newName;
    protected final String oldName;

    public UpdateTypeEntryChange(IFile file, TypeEntry typeEntry, String newName, String oldName) {
        this.file = file;
        this.typeEntry = typeEntry;
        this.newName = newName;
        this.oldName = oldName;
    }

    public String getName() {
        return Messages.Refactoring_UpdateTypeEntryChange;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        this.checkEditor(status, this.typeEntry, this.typeEntry.getTypeName());
        return status;
    }

    public void checkEditor(RefactoringStatus result, TypeEntry typeEntry, String oldName) {
        Display.getDefault().syncExec(() -> {
            IEditorPart[] findEditors = EditorUtils.findEditor(editor -> {
                FileEditorInput fei;
                IEditorInput iEditorInput = editor.getEditorInput();
                return iEditorInput instanceof FileEditorInput && (fei = (FileEditorInput)iEditorInput).getFile().equals((Object)typeEntry.getFile());
            });
            if (findEditors.length > 0 && findEditors[0].isDirty()) {
                if (this.shouldSaveFile(findEditors[0].getSite().getShell(), oldName)) {
                    findEditors[0].doSave((IProgressMonitor)new NullProgressMonitor());
                } else {
                    result.addFatalError("Abort rename as editor is dirty!");
                }
            }
        });
    }

    protected boolean shouldSaveFile(Shell shell, String oldName) {
        int result = MessageDialog.open((int)3, (Shell)shell, (String)"Rename of Type with unsaved changes!", (String)MessageFormat.format("There are unsaved changes for type \"{0}\". Do you want to save them before renaming?", oldName), (int)0, (String[])new String[]{"Save", "Cancel"});
        return result == 0;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        IFile newFile = this.findNewResource(this.newName);
        if (newFile != null && this.typeEntry != null) {
            UpdateTypeEntryChange.updateTypeEntryByRename(newFile, this.typeEntry);
            return new UpdateTypeEntryChange(newFile, this.typeEntry, this.oldName, this.newName);
        }
        return null;
    }

    private static void updateTypeEntryByRename(IFile newFile, TypeEntry entry) {
        String newTypeName = TypeEntry.getTypeNameFromFile((IFile)newFile);
        if (!Objects.equals(newFile, entry.getFile())) {
            TypeLibrary typeLibrary = entry.getTypeLibrary();
            if (typeLibrary != null) {
                typeLibrary.removeTypeEntry(entry);
            }
            entry.setFile(newFile);
            LibraryElement type = entry.copyType();
            if (type != null) {
                type.setName(newTypeName);
            }
            if (typeLibrary != null) {
                typeLibrary.addTypeEntry(entry);
            }
            try {
                entry.save(type);
            }
            catch (CoreException e) {
                FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            }
        }
    }

    public Object getModifiedElement() {
        return this.file;
    }

    private IFile findNewResource(String newName) {
        String fileEnding = this.file.getFullPath().getFileExtension();
        IPath newPath = fileEnding != null ? this.file.getFullPath().removeLastSegments(1).append(newName + "." + fileEnding) : this.file.getFullPath().removeLastSegments(1).append(newName);
        IResource findMember = ResourcesPlugin.getWorkspace().getRoot().findMember(newPath);
        if (findMember instanceof IFile) {
            IFile newFile = (IFile)findMember;
            return newFile;
        }
        return null;
    }

    public Object[] getAffectedObjects() {
        return new Object[]{this.file};
    }
}

