/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring.rename;

import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.typemanagement.refactoring.AbstractCommandChange;
import org.eclipse.gef.commands.Command;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class RenameElementChange
extends AbstractCommandChange<INamedElement> {
    private final String newName;
    private String oldName;

    public RenameElementChange(String name, URI elementURI, String newName) {
        super(name, elementURI, INamedElement.class);
        this.newName = newName;
    }

    @Override
    protected Command createCommand(INamedElement element) {
        return ChangeNameCommand.forName((INamedElement)element, (String)this.newName);
    }

    @Override
    public void initializeValidationData(INamedElement element, IProgressMonitor pm) {
        this.oldName = element.getName();
    }

    @Override
    public RefactoringStatus isValid(INamedElement element, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        if (!Objects.equals(element.getName(), this.oldName)) {
            status.addFatalError(Messages.RenameElementChange_NameChanged);
        } else if (!NameRepository.isValidName((INamedElement)element, (String)this.newName)) {
            status.addFatalError(Messages.RenameElementChange_InvalidName);
        }
        return status;
    }
}

