/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.segment.widget;

import org.eclipse.fordiac.ide.model.annotations.MappingAnnotations;
import org.eclipse.fordiac.ide.model.libraryElement.CommunicationChannel;
import org.eclipse.fordiac.ide.model.libraryElement.CommunicationMappingTarget;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.systemconfiguration.segment.Messages;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class MappedFbMenu {
    public static void addContextMenu(final TableViewer viewer) {
        final Menu menu = new Menu(viewer.getControl());
        final MenuItem openItem = MappedFbMenu.createMenuItem(viewer, menu);
        menu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                TableItem[] selection = viewer.getTable().getSelection();
                boolean isWindowSelected = selection.length > 0 && selection[0].getData() instanceof CommunicationMappingTarget;
                openItem.setEnabled(isWindowSelected);
                menu.setVisible(isWindowSelected);
            }

            public void menuHidden(MenuEvent e) {
                menu.setVisible(false);
            }
        });
        viewer.getControl().setMenu(menu);
    }

    private static MenuItem createMenuItem(final TableViewer viewer, Menu menu) {
        MenuItem openItem = new MenuItem(menu, 0);
        openItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CommunicationMappingTarget sel = MappedFbMenu.getSelectedWindow((Item[])viewer.getTable().getSelection());
                if (sel != null) {
                    MappedFbMenu.openDialog(sel);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        openItem.setText(Messages.TsnDetails_ShowMappedCommunicationFBs);
        return openItem;
    }

    private static CommunicationMappingTarget getSelectedWindow(Item[] selected) {
        Object object;
        if (selected.length > 0 && (object = selected[0].getData()) instanceof CommunicationMappingTarget) {
            CommunicationMappingTarget window = (CommunicationMappingTarget)object;
            return window;
        }
        return null;
    }

    private static void openDialog(CommunicationMappingTarget sel) {
        ITreeContentProvider treeProvider = MappedFbMenu.createTreeContentProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), MappedFbMenu.createLabelProvider(), treeProvider);
        dialog.setTitle(Messages.TsnDetails_ShowMappedCommunicationFBs);
        dialog.setInput((Object)sel);
        dialog.setHelpAvailable(false);
        dialog.setAllowMultiple(false);
        dialog.open();
    }

    private static ILabelProvider createLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof CommunicationChannel) {
                    CommunicationChannel channel = (CommunicationChannel)element;
                    return MappingAnnotations.getHierarchicalName((FBNetworkElement)channel) + "." + channel.getName();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                return FordiacImage.ICON_FB.getImage();
            }
        };
    }

    private static ITreeContentProvider createTreeContentProvider() {
        return new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof CommunicationMappingTarget) {
                    CommunicationMappingTarget target = (CommunicationMappingTarget)inputElement;
                    return target.getMappedElements().toArray();
                }
                return new Object[0];
            }

            public Object[] getChildren(Object parentElement) {
                return new Object[0];
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }
        };
    }

    private MappedFbMenu() {
        throw new UnsupportedOperationException();
    }
}

