/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.library;

import java.net.URI;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.fordiac.ide.library.LibraryRecord;
import org.eclipse.fordiac.ide.library.model.library.Manifest;
import org.eclipse.fordiac.ide.library.model.util.ManifestHelper;
import org.eclipse.fordiac.ide.library.model.util.VersionComparator;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

class ResolveNode {
    private final String symbolicName;
    private final Version version;
    private final URI uri;
    private final String error;
    private final Map<String, VersionRange> dependencies;
    private final boolean isReferenced;

    public ResolveNode(String symbolicName, String error) {
        this(symbolicName, Version.emptyVersion, null, error, false);
    }

    public ResolveNode(String symbolicName, Version version, URI uri, String error, boolean isReferenced) {
        this.symbolicName = symbolicName;
        this.version = version;
        this.uri = uri;
        this.error = error;
        this.isReferenced = isReferenced;
        this.dependencies = new HashMap<String, VersionRange>();
    }

    public ResolveNode(LibraryRecord lib) {
        this(lib.symbolicName(), lib.version(), lib.uri(), null, false);
        Manifest manifest = ManifestHelper.getFolderManifest((Path)lib.path());
        ResolveNode.addDependencies(this.dependencies, manifest);
    }

    public ResolveNode(String symbolicName, Version version, IProject project) {
        this(symbolicName, version, null, null, true);
        Manifest manifest = ManifestHelper.getReferencedManifest((IProject)project, (String)symbolicName);
        ResolveNode.addDependencies(this.dependencies, manifest);
    }

    private static void addDependencies(Map<String, VersionRange> dependencies, Manifest manifest) {
        if (manifest != null && manifest.getDependencies() != null) {
            manifest.getDependencies().getRequired().forEach(req -> {
                VersionRange versionRange = dependencies.put(req.getSymbolicName(), VersionComparator.parseVersionRange((String)req.getVersion()));
            });
        }
    }

    public boolean requireImport(Map<String, IFolder> linked, Map<String, Version> preferred) {
        return (!linked.containsKey(this.getSymbolicName()) || !preferred.get(this.getSymbolicName()).equals((Object)this.getVersion())) && !this.isReferenced();
    }

    public Version getVersion() {
        return this.version;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public Map<String, VersionRange> getDependencies() {
        return this.dependencies;
    }

    public boolean isValid() {
        return this.isReferenced || this.uri != null && this.error == null;
    }

    public String getError() {
        return this.error;
    }

    public boolean isReferenced() {
        return this.isReferenced;
    }
}

