/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.nat;

import org.eclipse.fordiac.ide.gef.dialogs.VariableDialog;
import org.eclipse.fordiac.ide.gef.nat.InitialValueCellEditor;
import org.eclipse.fordiac.ide.gef.nat.InitialValueStructuredElementAccessor;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.edit.editor.AbstractCellEditor;
import org.eclipse.nebula.widgets.nattable.widget.EditModeEnum;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class InitialValueStructuredCellEditor<T>
extends InitialValueCellEditor<T> {
    private Composite composite;
    private StyledText textControl;
    private Button dialogButton;

    public InitialValueStructuredCellEditor(IRowDataProvider<? extends T> dataProvider, InitialValueStructuredElementAccessor<T> elementAccessor) {
        super(dataProvider, elementAccessor);
    }

    public InitialValueStructuredCellEditor(IRowDataProvider<? extends T> dataProvider, InitialValueStructuredElementAccessor<T> elementAccessor, boolean moveSelectionOnEnter) {
        super(dataProvider, elementAccessor, moveSelectionOnEnter);
    }

    @Override
    protected Control activateCell(Composite parent, Object originalCanonicalValue) {
        super.activateCell(parent, originalCanonicalValue);
        return this.composite;
    }

    @Override
    protected StyledText createEditorControl(Composite parent, int style) {
        this.composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.composite);
        this.textControl = super.createEditorControl(this.composite, style);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.textControl);
        this.dialogButton = new Button(this.composite, 0x800000);
        this.dialogButton.setText("\u2026");
        this.dialogButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.openDialog()));
        GridDataFactory.swtDefaults().applyTo((Control)this.dialogButton);
        this.focusListener = new CompositeFocusListener();
        return this.textControl;
    }

    protected void openDialog() {
        try {
            String initialValue = FordiacMessages.ValueTooLarge.equals(this.getEditorValue()) ? null : this.getEditorValue();
            VariableDialog.open(this.composite.getShell(), this.getElementAccessor().getReferenceElement(this.getRowObject()), initialValue).ifPresent(this::setEditorValue);
        }
        finally {
            if (this.textControl != null && !this.textControl.isDisposed()) {
                this.textControl.forceFocus();
            }
        }
    }

    public void addEditorControlListeners() {
        super.addEditorControlListeners();
        if (this.editMode == EditModeEnum.INLINE) {
            if (this.textControl != null && !this.textControl.isDisposed()) {
                this.textControl.addFocusListener(this.focusListener);
            }
            if (this.dialogButton != null && !this.dialogButton.isDisposed()) {
                this.dialogButton.addFocusListener(this.focusListener);
            }
        }
    }

    public void removeEditorControlListeners() {
        super.removeEditorControlListeners();
        if (this.textControl != null && !this.textControl.isDisposed()) {
            this.textControl.removeFocusListener(this.focusListener);
        }
        if (this.dialogButton != null && !this.dialogButton.isDisposed()) {
            this.dialogButton.removeFocusListener(this.focusListener);
        }
    }

    @Override
    public Control getEditorControl() {
        return this.composite;
    }

    @Override
    protected InitialValueStructuredElementAccessor<T> getElementAccessor() {
        return (InitialValueStructuredElementAccessor)super.getElementAccessor();
    }

    protected class CompositeFocusListener
    extends AbstractCellEditor.InlineFocusListener {
        protected CompositeFocusListener() {
            super((AbstractCellEditor)InitialValueStructuredCellEditor.this);
        }

        public void focusLost(FocusEvent e) {
            Point cursorLocation = Display.getDefault().getCursorLocation();
            Point relativeCursorLocation = InitialValueStructuredCellEditor.this.dialogButton.getParent().toControl(cursorLocation);
            if (!InitialValueStructuredCellEditor.this.dialogButton.getBounds().contains(relativeCursorLocation)) {
                super.focusLost(e);
            }
        }
    }
}

