/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.annotation;

import org.eclipse.draw2d.IFigure;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationStyler;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationStyles;
import org.eclipse.fordiac.ide.model.ui.annotation.GraphicalAnnotation;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class ProblemAnnotationStyler
implements GraphicalAnnotationStyler {
    private static final String ERROR_COLOR = "org.eclipse.fordiac.ide.gef.errorColor";
    private static final String WARNING_COLOR = "org.eclipse.fordiac.ide.gef.warningColor";
    private static final String INFO_COLOR = "org.eclipse.fordiac.ide.gef.infoColor";

    @Override
    public void applyStyles(IFigure figure, GraphicalAnnotation annotation) {
        Color annotationColor = this.getColor(annotation);
        if (annotationColor != null) {
            GraphicalAnnotationStyles.setAnnotationFeedbackBorder(figure, annotationColor);
        }
    }

    @Override
    public void removeStyles(IFigure figure, GraphicalAnnotation annotation) {
        GraphicalAnnotationStyles.removeAnnotationBorders(figure);
    }

    @Override
    public Color getColor(GraphicalAnnotation annotation) {
        return switch (annotation.getType()) {
            case "org.eclipse.fordiac.ide.model.ui.annotation.error" -> JFaceResources.getColorRegistry().get(ERROR_COLOR);
            case "org.eclipse.fordiac.ide.model.ui.annotation.warning" -> JFaceResources.getColorRegistry().get(WARNING_COLOR);
            case "org.eclipse.fordiac.ide.model.ui.annotation.info" -> JFaceResources.getColorRegistry().get(INFO_COLOR);
            default -> null;
        };
    }

    @Override
    public Image getImage(GraphicalAnnotation annotation) {
        return switch (annotation.getType()) {
            case "org.eclipse.fordiac.ide.model.ui.annotation.error" -> PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
            case "org.eclipse.fordiac.ide.model.ui.annotation.warning" -> PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
            case "org.eclipse.fordiac.ide.model.ui.annotation.info" -> PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
            default -> null;
        };
    }

    @Override
    public Image getOverlayImage(GraphicalAnnotation annotation) {
        return null;
    }

    public static Color getErrorAnnotationColor() {
        return JFaceResources.getColorRegistry().get(ERROR_COLOR);
    }
}

