/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.watch;

import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugDevice;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugElement;
import org.eclipse.fordiac.ide.deployment.debug.watch.DeploymentDebugWatchUtils;
import org.eclipse.fordiac.ide.deployment.debug.watch.IWatch;
import org.eclipse.fordiac.ide.model.eval.EvaluatorException;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.CFBInstance;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;

public class BlockFBNetworkElementValue
extends DeploymentDebugElement
implements IValue {
    private static final String QUALIFIED_NAME_DELIMITER = ".";
    private final BlockFBNetworkElement element;
    private final Resource resource;
    private final String resourceRelativeName;
    private final List<IWatch> watches;

    public BlockFBNetworkElementValue(BlockFBNetworkElement element, DeploymentDebugDevice target) {
        this(element, element.getResource(), DeploymentDebugWatchUtils.getResourceRelativeName((INamedElement)element, element.getResource()), target);
    }

    public BlockFBNetworkElementValue(BlockFBNetworkElement element, Resource resource, String resourceRelativeName, DeploymentDebugDevice target) {
        super(target);
        this.element = element;
        this.resource = resource;
        this.resourceRelativeName = resourceRelativeName;
        this.watches = this.getSubElements().map(this::createSubWatch).toList();
    }

    private Stream<INamedElement> getSubElements() throws UnsupportedOperationException {
        return Stream.concat(this.getInterfaceSubElements(), this.getAdditionalSubElements()).sorted(Comparator.comparing(INamedElement::getName));
    }

    private Stream<INamedElement> getInterfaceSubElements() throws UnsupportedOperationException {
        InterfaceList interfaceList = this.element.getInterface();
        return Stream.of(interfaceList.getEventInputs(), interfaceList.getEventOutputs(), interfaceList.getInputVars(), interfaceList.getOutputVars(), interfaceList.getInOutVars(), interfaceList.getSockets(), interfaceList.getPlugs()).flatMap(Collection::stream);
    }

    private Stream<? extends INamedElement> getAdditionalSubElements() throws UnsupportedOperationException {
        Stream<Object> stream;
        BlockFBNetworkElement blockFBNetworkElement;
        BlockFBNetworkElement blockFBNetworkElement2 = this.element;
        Objects.requireNonNull(blockFBNetworkElement2);
        BlockFBNetworkElement blockFBNetworkElement3 = blockFBNetworkElement = blockFBNetworkElement2;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FB.class, SubApp.class, CFBInstance.class}, (Object)blockFBNetworkElement3, n)) {
                case 0: {
                    FB fb = (FB)blockFBNetworkElement;
                    FBType fBType = fb.getType();
                    if (!(fBType instanceof BaseFBType)) {
                        blockFBNetworkElement3 = blockFBNetworkElement;
                        n = 1;
                        continue block5;
                    }
                    BaseFBType baseFBType = (BaseFBType)fBType;
                    stream = Stream.concat(baseFBType.getInternalVars().stream(), baseFBType.getInternalFbs().stream());
                    break block5;
                }
                case 1: {
                    SubApp subapp = (SubApp)blockFBNetworkElement;
                    stream = subapp.loadSubAppNetwork().getBlockFBNetworkElements();
                    break block5;
                }
                case 2: {
                    CFBInstance cfbInstance = (CFBInstance)blockFBNetworkElement;
                    stream = cfbInstance.loadCFBNetwork().getBlockFBNetworkElements().filter(Predicate.not(AdapterFB.class::isInstance));
                    break block5;
                }
                default: {
                    stream = Stream.empty();
                }
            }
            break;
        }
        return stream;
    }

    private IWatch createSubWatch(INamedElement element) throws EvaluatorException, UnsupportedOperationException {
        if (EcoreUtil.getRootContainer((EObject)element) instanceof FBType) {
            return IWatch.watchFor(element.getName(), element, this.resource, this.resourceRelativeName + QUALIFIED_NAME_DELIMITER + element.getName(), this.getDebugTarget());
        }
        return IWatch.watchFor(element.getName(), element, this.getDebugTarget());
    }

    public BlockFBNetworkElement getElement() {
        return this.element;
    }

    public List<IWatch> getWatches() {
        return this.watches;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.element.getTypeName();
    }

    public String getValueString() throws DebugException {
        return "";
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        return (IVariable[])this.watches.toArray(IVariable[]::new);
    }

    public boolean hasVariables() throws DebugException {
        return !this.watches.isEmpty();
    }

    @Override
    public DeploymentDebugDevice getDebugTarget() {
        return (DeploymentDebugDevice)super.getDebugTarget();
    }
}

