/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.ui.actions;

import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.model.elements.VariableContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.fordiac.ide.debug.ui.Messages;
import org.eclipse.fordiac.ide.debug.ui.actions.EvaluatorDebugFindDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IUpdate;

public class EvaluatorDebugFindAction
extends Action
implements IUpdate {
    private static final String ID = "org.eclipse.fordiac.ide.debug.ui.FindElementAction";
    private final IStackFrame stackFrame;
    private final IPresentationContext context;
    private final InternalVariableContentProvider contentProvider = new InternalVariableContentProvider();

    public EvaluatorDebugFindAction(IStackFrame stackFrame, IPresentationContext context) {
        this.stackFrame = stackFrame;
        this.context = context;
        this.setId(ID);
        this.setText(Messages.EvaluatorDebugFindAction_Text);
        this.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
    }

    public void run() {
        Object object;
        Object[] elements;
        Shell shell = this.context.getPart().getSite().getShell();
        EvaluatorDebugFindDialog dialog = new EvaluatorDebugFindDialog(shell, this.stackFrame);
        if (dialog.open() == 0 && (elements = dialog.getResult()) != null && elements.length == 1 && (object = elements[0]) instanceof IVariable) {
            IVariable variable = (IVariable)object;
            try {
                this.selectAndReveal(variable);
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)shell, null, null, (IStatus)e.getStatus());
            }
        }
    }

    protected void selectAndReveal(IVariable variable) throws CoreException {
        VariablesView variablesView;
        Viewer viewer;
        IWorkbenchPart iWorkbenchPart = this.context.getPart();
        if (iWorkbenchPart instanceof VariablesView && (viewer = (variablesView = (VariablesView)iWorkbenchPart).getViewer()) instanceof TreeModelViewer) {
            TreeModelViewer viewer2 = (TreeModelViewer)viewer;
            this.selectAndReveal(variable, viewer2);
        }
    }

    protected void selectAndReveal(IVariable variable, TreeModelViewer viewer) throws CoreException {
        ModelDelta root = new ModelDelta(viewer.getInput(), 0);
        this.buildModelDelta(root, this.stackFrame.getVariables(), variable);
        viewer.updateViewer((IModelDelta)root);
    }

    protected ModelDelta buildModelDelta(ModelDelta delta, IVariable[] variables, IVariable target) throws CoreException {
        int index = 0;
        while (index < variables.length) {
            IVariable variable = variables[index];
            IVariable[] children = this.contentProvider.getValueChildren((IDebugElement)variable, variable.getValue(), this.context);
            if (variable == target) {
                return delta.addNode((Object)variable, index, 0x4200000, children.length);
            }
            if (EvaluatorDebugFindAction.isAncestor(variable, target)) {
                return this.buildModelDelta(delta.addNode((Object)variable, index, 0x100000, children.length), children, target);
            }
            ++index;
        }
        return delta;
    }

    protected static boolean isAncestor(IVariable variable, IVariable target) throws DebugException {
        IVariable[] iVariableArray = variable.getValue().getVariables();
        int n = iVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVariable child = iVariableArray[n2];
            if (child == target || EvaluatorDebugFindAction.isAncestor(child, target)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void update() {
        try {
            this.setEnabled(this.stackFrame != null && this.stackFrame.hasVariables());
        }
        catch (DebugException e) {
            this.setEnabled(false);
        }
    }

    private static class InternalVariableContentProvider
    extends VariableContentProvider {
        private InternalVariableContentProvider() {
        }

        protected IVariable[] getValueChildren(IDebugElement parent, IValue value, IPresentationContext context) throws CoreException {
            Object[] children = super.getValueChildren(parent, value, context);
            if (children instanceof IVariable[]) {
                IVariable[] variableChildren = (IVariable[])children;
                return variableChildren;
            }
            return (IVariable[])Arrays.copyOf(children, children.length, IVariable[].class);
        }
    }
}

