/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.marker.resolution;

import java.text.MessageFormat;
import java.util.stream.Stream;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.application.marker.resolution.AbstractCommandMarkerResolution;
import org.eclipse.fordiac.ide.model.commands.change.ChangeAttributeDeclarationCommand;
import org.eclipse.fordiac.ide.model.errormarker.FordiacErrorMarker;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.typelibrary.AttributeTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.Image;

public class BestFitAttributeMarkerResolution
extends AbstractCommandMarkerResolution<Attribute> {
    private final AttributeTypeEntry selectedAttribute;

    protected BestFitAttributeMarkerResolution(IMarker marker, AttributeTypeEntry selectedAttribute) {
        super(marker, Attribute.class);
        this.selectedAttribute = selectedAttribute;
    }

    @Override
    protected boolean prepare(IMarker[] markers, IProgressMonitor monitor) throws CoreException {
        return true;
    }

    @Override
    protected Command createCommand(Attribute element, IProgressMonitor monitor) throws CoreException {
        return ChangeAttributeDeclarationCommand.forName((Attribute)element, (String)this.selectedAttribute.getFullTypeName());
    }

    public static Stream<BestFitAttributeMarkerResolution> createResolutions(IMarker marker) {
        String attrName = null;
        EObject eObject = FordiacErrorMarker.getTarget((IMarker)marker);
        if (eObject instanceof Attribute) {
            Attribute attr = (Attribute)eObject;
            attrName = PackageNameHelper.extractPlainTypeName((String)attr.getName());
        }
        if (attrName == null) {
            return Stream.empty();
        }
        String name = attrName;
        TypeLibrary typeLibrary = TypeLibraryManager.INSTANCE.getTypeLibrary(marker.getResource().getProject());
        return typeLibrary.getAttributeTypes().filter(type -> type.getTypeName().equals(name)).map(typeEntry -> new BestFitAttributeMarkerResolution(marker, (AttributeTypeEntry)typeEntry));
    }

    public String getDescription() {
        return MessageFormat.format(FordiacMessages.Repair_Dialog_BestFitAttrType, this.selectedAttribute.getFullTypeName());
    }

    public Image getImage() {
        return null;
    }

    public String getLabel() {
        return MessageFormat.format(FordiacMessages.Repair_Dialog_BestFitAttrType, this.selectedAttribute.getFullTypeName());
    }
}

