/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.tools;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.fordiac.ide.model.commands.create.AbstractConnectionCreateCommand;
import org.eclipse.fordiac.ide.ui.UIPlugin;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.tools.ConnectionDragCreationTool;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;

public class FordiacConnectionDragCreationTool
extends ConnectionDragCreationTool {
    EditPartViewer initialViewer;

    public FordiacConnectionDragCreationTool() {
        this.setDefaultCursor(Display.getDefault().getSystemCursor(2));
        this.setDisabledCursor(Display.getDefault().getSystemCursor(20));
    }

    public void deactivate() {
        FordiacConnectionDragCreationTool.stopHover();
        super.deactivate();
    }

    protected boolean handleMove() {
        if (this.isInState(97)) {
            this.updateTargetRequest();
            this.updateTargetUnderMouse();
            this.showSourceFeedback();
            this.showTargetFeedback();
            this.setCurrentCommand(this.getCommand());
        }
        return true;
    }

    public void mouseDown(MouseEvent me, EditPartViewer viewer) {
        this.initialViewer = viewer;
        super.mouseDown(me, viewer);
    }

    public void mouseUp(MouseEvent me, EditPartViewer viewer) {
        if ((me.stateMask & SWT.MOD2) != 0) {
            this.checkCurrentCommandforShiftMask();
        }
        super.mouseUp(me, viewer);
        this.initialViewer = null;
    }

    protected void setCursor(Cursor cursor) {
        if (this.isInState(68) && this.initialViewer != null && this.getCurrentViewer() != null && this.initialViewer != this.getCurrentViewer()) {
            this.initialViewer.setCursor(cursor);
        } else {
            super.setCursor(cursor);
        }
    }

    protected void showSourceFeedback() {
        if (this.differentTargetViewer()) {
            Point location = this.getLocation();
            Point converted = new Point(this.initialViewer.getControl().toControl(this.getCurrentViewer().getControl().toDisplay(location.x, location.y)));
            this.getTargetRequest().setLocation(converted);
        }
        super.showSourceFeedback();
        if (this.differentTargetViewer()) {
            this.getTargetRequest().setLocation(this.getLocation());
        }
    }

    private boolean differentTargetViewer() {
        return this.initialViewer != null && this.initialViewer != this.getCurrentViewer();
    }

    private void checkCurrentCommandforShiftMask() {
        Command curCmd = this.getCurrentCommand();
        if (curCmd instanceof AbstractConnectionCreateCommand) {
            AbstractConnectionCreateCommand conCreateCmd = (AbstractConnectionCreateCommand)curCmd;
            conCreateCmd.setVisible(false);
        }
    }

    protected void setCurrentCommand(Command c) {
        if (this.getCurrentCommand() == null && c != null) {
            FordiacConnectionDragCreationTool.startHover();
        } else if (this.getCurrentCommand() != null && c != null && c != this.getCurrentCommand()) {
            FordiacConnectionDragCreationTool.stopHover();
            FordiacConnectionDragCreationTool.startHover();
        } else if (this.getCurrentCommand() != null && c == null) {
            FordiacConnectionDragCreationTool.stopHover();
        }
        super.setCurrentCommand(c);
    }

    protected void setInitialViewer(EditPartViewer initialViewer) {
        this.initialViewer = initialViewer;
    }

    private static void startHover() {
        UIPlugin.getDefault().getEMH().setHover(true);
    }

    private static void stopHover() {
        UIPlugin.getDefault().getEMH().setHover(false);
    }
}

