/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.AdapterTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.gef.commands.Command;

public class UpdateInternalFBCommand
extends Command
implements ScopedCommand {
    private FB newElement;
    private final FB oldElement;
    private final TypeEntry entry;
    private final BaseFBType baseFbType;
    private int index;

    public UpdateInternalFBCommand(FB fb, TypeEntry entry) {
        this.oldElement = Objects.requireNonNull(fb);
        this.entry = Objects.requireNonNull(entry);
        this.baseFbType = (BaseFBType)fb.eContainer();
    }

    private EList<FB> getInteralFBList() {
        return this.baseFbType.getInternalFbs();
    }

    public boolean canExecute() {
        if (this.oldElement == null || this.entry == null || this.baseFbType == null) {
            return false;
        }
        return super.canExecute();
    }

    protected void createNewFB() {
        this.newElement = this.createCopiedFBEntry((FBNetworkElement)this.oldElement);
        this.newElement.setInterface(this.newElement.getTypeInterface().instanceCopy());
        this.newElement.setName(this.oldElement.getName());
        this.createValues();
        this.transferInstanceComments();
    }

    protected FB createCopiedFBEntry(FBNetworkElement srcElement) {
        Object copy;
        if (this.entry instanceof AdapterTypeEntry) {
            copy = LibraryElementFactory.eINSTANCE.createAdapterFB();
            copy.setAdapterDecl(((AdapterFB)srcElement).getAdapterDecl());
        } else {
            copy = LibraryElementPackage.Literals.COMPOSITE_FB_TYPE.equals(this.entry.getTypeEClass()) ? LibraryElementFactory.eINSTANCE.createCFBInstance() : LibraryElementFactory.eINSTANCE.createFB();
        }
        copy.setTypeEntry(this.entry);
        return copy;
    }

    protected void createValues() {
        this.newElement.getInterface().getInputVars().stream().forEach(inVar -> {
            inVar.setValue(LibraryElementFactory.eINSTANCE.createValue());
            this.checkSourceParam((VarDeclaration)inVar);
        });
    }

    private void checkSourceParam(VarDeclaration variable) {
        VarDeclaration srcVar = this.oldElement.getInterface().getVariable(variable.getName());
        if (srcVar != null && srcVar.getValue() != null) {
            variable.getValue().setValue(srcVar.getValue().getValue());
        }
    }

    protected void transferInstanceComments() {
        this.oldElement.getInterface().getAllInterfaceElements().filter(ie -> !ie.getComment().isBlank()).forEach(ie -> {
            IInterfaceElement newIE = this.newElement.getInterface().getInterfaceElement(ie);
            if (newIE != null) {
                newIE.setComment(ie.getComment());
            }
        });
    }

    public void execute() {
        this.createNewFB();
        this.index = this.getIndexOfFB();
        this.redo();
    }

    public void redo() {
        this.getInteralFBList().set(this.index, (Object)this.newElement);
    }

    public void undo() {
        this.getInteralFBList().set(this.index, (Object)this.oldElement);
    }

    private int getIndexOfFB() {
        return this.getInteralFBList().indexOf((Object)this.getInteralFBList().stream().filter(fb -> fb.getName().equals(this.oldElement.getName())).findFirst().orElse(this.oldElement));
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        return Set.of(this.baseFbType);
    }
}

