/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.ui.errormessages.ErrorMessenger;
import org.eclipse.gef.commands.Command;

public class ChangePinVisibilityCommand
extends Command
implements ScopedCommand {
    private final IInterfaceElement interfaceElement;
    private final boolean visible;

    public ChangePinVisibilityCommand(BlockFBNetworkElement fb, List<String> path, boolean visible) {
        this(fb.getInterface().getInterfaceElement(path, visible), visible);
    }

    public ChangePinVisibilityCommand(IInterfaceElement interfaceElement, boolean visible) {
        this.interfaceElement = Objects.requireNonNull(interfaceElement);
        this.visible = visible;
    }

    public void execute() {
        this.interfaceElement.setVisible(this.visible);
    }

    public void redo() {
        this.interfaceElement.setVisible(this.visible);
    }

    public void undo() {
        this.interfaceElement.setVisible(!this.visible);
    }

    public boolean canExecute() {
        if (!this.visible && ChangePinVisibilityCommand.isConnectedInsideSubApp(this.interfaceElement)) {
            ErrorMessenger.popUpErrorMessage((String)Messages.HidePinCommand_PinCannotBeHidden_ConnectedInside);
            return false;
        }
        return (this.interfaceElement instanceof VarDeclaration || this.interfaceElement instanceof AdapterDeclaration) && (this.interfaceElement.isIsInput() && this.interfaceElement.getInputConnections().isEmpty() || !this.interfaceElement.isIsInput() && this.interfaceElement.getOutputConnections().isEmpty()) && !ChangePinVisibilityCommand.isExpandedSubAppPinAndConnected(this.interfaceElement);
    }

    protected static boolean isExpandedSubAppPinAndConnected(IInterfaceElement interfaceElement) {
        SubApp subApp;
        BlockFBNetworkElement blockFBNetworkElement = interfaceElement.getBlockFBNetworkElement();
        return blockFBNetworkElement instanceof SubApp && (subApp = (SubApp)blockFBNetworkElement).isUnfolded() && !interfaceElement.getInputConnections().isEmpty() && !interfaceElement.getOutputConnections().isEmpty();
    }

    private static boolean isConnectedInsideSubApp(IInterfaceElement element) {
        if (element instanceof VarDeclaration) {
            EObject eObject;
            VarDeclaration varDecl = (VarDeclaration)element;
            if (element.isIsInput() && (eObject = element.eContainer().eContainer()) instanceof SubAppType) {
                SubAppType sat = (SubAppType)eObject;
                return sat.getFBNetwork().getBlockFBNetworkElements().anyMatch(fb -> {
                    IInterfaceElement internal = fb.getInterface().getInterfaceElement((IInterfaceElement)varDecl);
                    return internal != null && !internal.getInputConnections().isEmpty();
                });
            }
        }
        return false;
    }

    protected IInterfaceElement getInterfaceElement() {
        return this.interfaceElement;
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        return Set.of(this.interfaceElement);
    }
}

