/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.filterrow;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.filterrow.IFilterStrategy;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.FilterRowComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.event.FilterAppliedEvent;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.LayerCell;
import org.eclipse.nebula.widgets.nattable.persistence.IPersistable;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;
import org.eclipse.nebula.widgets.nattable.util.PersistenceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterRowDataProvider<T>
implements IDataProvider,
IPersistable {
    private static final Logger LOG = LoggerFactory.getLogger(FilterRowDataProvider.class);
    public static final String PIPE_REPLACEMENT = "\u00b0~\u00b0";
    public static final String COMMA_REPLACEMENT = "\u00b0#\u00b0";
    public static final String NULL_REPLACEMENT = "\u00b0null\u00b0";
    public static final String EMPTY_REPLACEMENT = "\u00b0empty\u00b0";
    public static final String FILTER_COLLECTION_PREFIX = "\u00b0coll(";
    private final IFilterStrategy<T> filterStrategy;
    private final ILayer columnHeaderLayer;
    private final IDataProvider columnHeaderDataProvider;
    private final IConfigRegistry configRegistry;
    private Map<Integer, Object> filterIndexToObjectMap = new HashMap<Integer, Object>();
    private FilterRowComboBoxDataProvider<T> filterRowComboBoxDataProvider;

    public FilterRowDataProvider(IFilterStrategy<T> filterStrategy, ILayer columnHeaderLayer, IDataProvider columnHeaderDataProvider, IConfigRegistry configRegistry) {
        this.filterStrategy = filterStrategy;
        this.columnHeaderLayer = columnHeaderLayer;
        this.columnHeaderDataProvider = columnHeaderDataProvider;
        this.configRegistry = configRegistry;
    }

    public Map<Integer, Object> getFilterIndexToObjectMap() {
        return this.filterIndexToObjectMap;
    }

    public void setFilterIndexToObjectMap(Map<Integer, Object> filterIndexToObjectMap) {
        this.filterIndexToObjectMap = filterIndexToObjectMap;
    }

    @Override
    public int getColumnCount() {
        return this.columnHeaderDataProvider.getColumnCount();
    }

    @Override
    public Object getDataValue(int columnIndex, int rowIndex) {
        return this.filterIndexToObjectMap.get(columnIndex);
    }

    @Override
    public int getRowCount() {
        return 1;
    }

    @Override
    public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
        boolean cleared = false;
        Object oldValue = this.filterIndexToObjectMap.get(columnIndex);
        if (newValue != null && newValue.toString().length() > 0) {
            if (!newValue.equals(oldValue)) {
                this.filterIndexToObjectMap.put(columnIndex, newValue);
            }
        } else {
            cleared = true;
            if (oldValue != null) {
                this.filterIndexToObjectMap.remove(columnIndex);
            }
        }
        this.filterStrategy.applyFilter(this.filterIndexToObjectMap);
        this.columnHeaderLayer.fireLayerEvent(new FilterAppliedEvent(this.columnHeaderLayer, columnIndex, oldValue, newValue, cleared));
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        HashMap<Integer, String> filterTextByIndex = new HashMap<Integer, String>();
        for (Integer columnIndex : this.filterIndexToObjectMap.keySet()) {
            IDisplayConverter converter = this.configRegistry.getConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, DisplayMode.NORMAL, "FILTER_COLUMN_" + String.valueOf(columnIndex));
            String filterText = this.getFilterStringRepresentation(columnIndex, converter);
            filterText = filterText.replace("|", PIPE_REPLACEMENT);
            filterTextByIndex.put(columnIndex, filterText);
        }
        String string = PersistenceUtils.mapAsString(filterTextByIndex);
        if (!ObjectUtils.isEmpty(string)) {
            properties.put(prefix + ".filterTokens", string);
        } else {
            properties.remove(prefix + ".filterTokens");
        }
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        this.filterIndexToObjectMap.clear();
        try {
            Object property = properties.get(prefix + ".filterTokens");
            Map<Integer, String> filterTextByIndex = PersistenceUtils.parseString(property);
            for (Integer columnIndex : filterTextByIndex.keySet()) {
                IDisplayConverter converter = this.configRegistry.getConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, DisplayMode.NORMAL, "FILTER_COLUMN_" + String.valueOf(columnIndex));
                String filterText = filterTextByIndex.get(columnIndex);
                filterText = filterText.replace(PIPE_REPLACEMENT, "|");
                this.filterIndexToObjectMap.put(columnIndex, this.getFilterFromString(columnIndex, filterText, converter));
            }
        }
        catch (Exception e) {
            LOG.error("Error while restoring filter row text!", (Throwable)e);
        }
        this.filterStrategy.applyFilter(this.filterIndexToObjectMap);
        this.columnHeaderLayer.fireLayerEvent(new FilterAppliedEvent(this.columnHeaderLayer));
    }

    private String getFilterStringRepresentation(int columnIndex, IDisplayConverter converter) {
        Object filterValue = this.filterIndexToObjectMap.get(columnIndex);
        if (filterValue instanceof Collection) {
            String collectionSpec = FILTER_COLLECTION_PREFIX + filterValue.getClass().getName() + ")";
            StringBuilder builder = new StringBuilder(collectionSpec);
            builder.append("[");
            Collection filterCollection = (Collection)filterValue;
            if (this.filterRowComboBoxDataProvider == null) {
                Iterator iterator = filterCollection.iterator();
                while (iterator.hasNext()) {
                    Object filterObject = iterator.next();
                    String displayValue = (String)converter.canonicalToDisplayValue(new LayerCell(null, columnIndex, 0), this.configRegistry, filterObject);
                    displayValue = displayValue.replace(",", COMMA_REPLACEMENT);
                    builder.append(displayValue);
                    if (!iterator.hasNext()) continue;
                    builder.append(",");
                }
            } else {
                ArrayList allValues = new ArrayList(this.filterRowComboBoxDataProvider.getAllValues(columnIndex));
                allValues.removeAll(filterCollection);
                Iterator iterator = allValues.iterator();
                while (iterator.hasNext()) {
                    Object filterObject = iterator.next();
                    if (filterObject == null) {
                        builder.append(NULL_REPLACEMENT);
                    } else {
                        String displayValue = (String)converter.canonicalToDisplayValue(new LayerCell(null, columnIndex, 0), this.configRegistry, filterObject);
                        if ((displayValue = displayValue.replace(",", COMMA_REPLACEMENT)).isEmpty()) {
                            builder.append(EMPTY_REPLACEMENT);
                        } else {
                            builder.append(displayValue);
                        }
                    }
                    if (!iterator.hasNext()) continue;
                    builder.append(",");
                }
            }
            builder.append("]");
            return builder.toString();
        }
        return (String)converter.canonicalToDisplayValue(new LayerCell(null, columnIndex, 0), this.configRegistry, filterValue);
    }

    private Object getFilterFromString(int columnIndex, String filterText, IDisplayConverter converter) throws InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        if (filterText.startsWith(FILTER_COLLECTION_PREFIX)) {
            int indexEndCollSpec = filterText.indexOf(")");
            String collectionSpec = filterText.substring(filterText.indexOf("(") + 1, indexEndCollSpec);
            Collection filterCollection = (Collection)Class.forName(collectionSpec).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (!(filterText = filterText.substring(indexEndCollSpec + 2, filterText.length() - 1)).isEmpty()) {
                String[] filterSplit;
                String[] stringArray = filterSplit = filterText.split(",");
                int n = filterSplit.length;
                int n2 = 0;
                while (n2 < n) {
                    String filterString = stringArray[n2];
                    if (NULL_REPLACEMENT.equals(filterString = filterString.replace(COMMA_REPLACEMENT, ","))) {
                        filterCollection.add(null);
                    } else if (EMPTY_REPLACEMENT.equals(filterString)) {
                        filterCollection.add("");
                    } else {
                        filterCollection.add(converter.displayToCanonicalValue(new LayerCell(null, columnIndex, 0), this.configRegistry, filterString));
                    }
                    ++n2;
                }
            }
            if (this.filterRowComboBoxDataProvider != null) {
                if (filterCollection.isEmpty()) {
                    return "SELECT_ALL";
                }
                ArrayList allValues = new ArrayList(this.filterRowComboBoxDataProvider.getAllValues(columnIndex));
                allValues.removeAll(filterCollection);
                return allValues;
            }
            return filterCollection;
        }
        return converter.displayToCanonicalValue(new LayerCell(null, columnIndex, 0), this.configRegistry, filterText);
    }

    public void clearAllFilters() {
        this.filterIndexToObjectMap.clear();
        this.filterStrategy.applyFilter(this.filterIndexToObjectMap);
        this.columnHeaderLayer.fireLayerEvent(new FilterAppliedEvent(this.columnHeaderLayer, true));
    }

    public IFilterStrategy<T> getFilterStrategy() {
        return this.filterStrategy;
    }

    public void setFilterRowComboBoxDataProvider(FilterRowComboBoxDataProvider<T> comboBoxDataProvider) {
        this.filterRowComboBoxDataProvider = comboBoxDataProvider;
    }
}

