/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.libraryElement.impl;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.fordiac.ide.model.IdentifierVerifier;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;

public final class NamedElementAnnotations {
    static final String QUALIFIED_NAME_DELIMITER = ".";

    public static String getQualifiedName(INamedElement element) {
        INamedElement namedContainer = NamedElementAnnotations.getNamedContainer(element);
        if (namedContainer != null && namedContainer.eContainer() != null) {
            return namedContainer.getQualifiedName() + QUALIFIED_NAME_DELIMITER + element.getName();
        }
        return element.getName();
    }

    public static String getRelativeName(INamedElement element, INamedElement to) {
        INamedElement namedContainer = NamedElementAnnotations.getNamedContainer(element);
        if (namedContainer != null && namedContainer.eContainer() != null && namedContainer != to) {
            return namedContainer.getRelativeName(to) + QUALIFIED_NAME_DELIMITER + element.getName();
        }
        return element.getName();
    }

    static INamedElement getNamedContainer(EObject object) {
        while (object != null) {
            if (!((object = object.eContainer()) instanceof INamedElement)) continue;
            INamedElement element = (INamedElement)object;
            return element;
        }
        return null;
    }

    static String removeQualifiedNamePrefix(String s, String prefix) {
        if (s.startsWith(prefix + QUALIFIED_NAME_DELIMITER)) {
            return s.substring(prefix.length() + QUALIFIED_NAME_DELIMITER.length());
        }
        return s;
    }

    public static Stream<INamedElement> findBySimpleName(INamedElement root, String name) {
        return StreamSupport.stream(new NamedContentsSpliterator(root, name), false);
    }

    public static Stream<INamedElement> findByQualifiedName(INamedElement root, String qualifiedName) {
        int separator = qualifiedName.indexOf(46);
        if (separator >= 0) {
            String head = qualifiedName.substring(0, separator);
            String tail = qualifiedName.substring(separator + 1);
            return root.findBySimpleName(head).flatMap(element -> element.findByQualifiedName(tail));
        }
        return root.findBySimpleName(qualifiedName);
    }

    public static boolean validateName(INamedElement element, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (element.getName() != null && !element.getName().isEmpty()) {
            if (element.getName().contains("__")) {
                if (diagnostics != null) {
                    diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.fordiac.ide.model.libraryElement", 26, MessageFormat.format(Messages.IdentifierVerifier_NameConsecutiveUnderscore, element.getName()), FordiacMarkerHelper.getDiagnosticData((EObject)element, (EStructuralFeature)LibraryElementPackage.Literals.INAMED_ELEMENT__NAME, element.getName())));
                }
            } else if (element.getName().endsWith("_")) {
                if (diagnostics != null) {
                    diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.fordiac.ide.model.libraryElement", 26, MessageFormat.format(Messages.IdentifierVerifier_NameTrailingUnderscore, element.getName()), FordiacMarkerHelper.getDiagnosticData((EObject)element, (EStructuralFeature)LibraryElementPackage.Literals.INAMED_ELEMENT__NAME, new String[0])));
                }
            } else {
                Optional<String> errorMessage = IdentifierVerifier.verifyIdentifier(element.getName(), element);
                if (errorMessage.isPresent()) {
                    if (diagnostics != null) {
                        diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.fordiac.ide.model.libraryElement", 26, errorMessage.get(), FordiacMarkerHelper.getDiagnosticData((EObject)element, (EStructuralFeature)LibraryElementPackage.Literals.INAMED_ELEMENT__NAME, new String[0])));
                    }
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean validateDuplicateName(INamedElement element, DiagnosticChain diagnostics, Map<Object, Object> context, String key) {
        Map<String, INamedElement> namedContents = NamedElementAnnotations.getNamedContents(context, key);
        INamedElement duplicate = NamedElementAnnotations.putConditional(namedContents, element.getQualifiedName().toLowerCase(), element, NullNamedElement.INSTANCE);
        if (duplicate != null) {
            if (diagnostics != null) {
                if (!(duplicate instanceof NullNamedElement)) {
                    diagnostics.add(NamedElementAnnotations.createDuplicateNameDiagnostic(duplicate));
                }
                diagnostics.add(NamedElementAnnotations.createDuplicateNameDiagnostic(element));
            }
            return false;
        }
        return true;
    }

    private static Diagnostic createDuplicateNameDiagnostic(INamedElement element) {
        return new BasicDiagnostic(4, "org.eclipse.fordiac.ide.model.libraryElement", 26, MessageFormat.format(Messages.InterfaceElementAnnotations_DuplicateName, element.getName()), FordiacMarkerHelper.getDiagnosticData((EObject)element, (EStructuralFeature)LibraryElementPackage.Literals.INAMED_ELEMENT__NAME, element.getQualifiedName()));
    }

    private static <K, V> V putConditional(Map<K, V> map, K key, V valueIfAbsent, V valueIfPresent) {
        V v = map.get(key);
        v = v == null ? map.put(key, valueIfAbsent) : map.put(key, valueIfPresent);
        return v;
    }

    private static Map<String, INamedElement> getNamedContents(Map<Object, Object> context, String key) {
        return (Map)context.computeIfAbsent(key, k -> new HashMap());
    }

    private NamedElementAnnotations() {
        throw new UnsupportedOperationException("Helper class must not be instantiated");
    }

    private static class NamedContentsSpliterator
    implements Spliterator<INamedElement> {
        private final String name;
        private final TreeIterator<EObject> contents;

        private NamedContentsSpliterator(INamedElement root, String name) {
            this.name = name;
            this.contents = root.eAllContents();
        }

        @Override
        public boolean tryAdvance(Consumer<? super INamedElement> action) {
            while (this.contents.hasNext()) {
                EObject element = (EObject)this.contents.next();
                if (!(element instanceof INamedElement)) continue;
                INamedElement namedElement = (INamedElement)element;
                if (Objects.equals(namedElement.getName(), this.name)) {
                    action.accept(namedElement);
                    return true;
                }
                this.contents.prune();
            }
            return false;
        }

        @Override
        public Spliterator<INamedElement> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 273;
        }
    }

    private static class NullNamedElement
    extends EObjectImpl
    implements INamedElement {
        private static final NullNamedElement INSTANCE = new NullNamedElement();

        private NullNamedElement() {
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public void setName(String value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getComment() {
            return null;
        }

        @Override
        public void setComment(String value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getQualifiedName() {
            return null;
        }

        @Override
        public String getRelativeName(INamedElement to) {
            return null;
        }

        @Override
        public Stream<INamedElement> findBySimpleName(String name) {
            return Stream.empty();
        }

        @Override
        public Stream<INamedElement> findByQualifiedName(String name) {
            return Stream.empty();
        }

        @Override
        public boolean validateName(DiagnosticChain diagnostics, Map<Object, Object> context) {
            return false;
        }
    }
}

