/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.annotation;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.fordiac.ide.model.ui.annotation.GraphicalAnnotation;

public class GraphicalMarkerAnnotation
extends GraphicalAnnotation {
    private final IMarker marker;
    private String text;
    private String location;
    private Map<String, Object> attributes;

    protected GraphicalMarkerAnnotation(IMarker marker, String type, Object target) {
        super(type, target);
        this.marker = marker;
        this.refresh();
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public Object getAttribute(String attributeName) {
        return this.attributes.get(attributeName);
    }

    @Override
    public Map<String, Object> getAttributes() {
        try {
            return Objects.requireNonNullElse(this.marker.getAttributes(), Collections.emptyMap());
        }
        catch (CoreException e) {
            return Collections.emptyMap();
        }
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    public void refresh() {
        this.text = this.marker.getAttribute("message", null);
        this.location = this.marker.getAttribute("location", null);
        try {
            this.attributes = this.marker.getAttributes();
        }
        catch (CoreException e) {
            this.attributes = Map.of();
        }
    }

    public IMarker getMarker() {
        return this.marker;
    }

    public int hashCode() {
        return Objects.hashCode(this.marker);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphicalMarkerAnnotation other = (GraphicalMarkerAnnotation)obj;
        return Objects.equals(this.marker, other.marker);
    }
}

