/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.richtext;

import org.eclipse.swt.widgets.Display;

public final class ScalingHelper {
    private ScalingHelper() {
    }

    public static float getDpiFactor(int dpi) {
        return Math.max(0.1f, (float)Math.round((float)dpi / 96.0f * 100.0f) / 100.0f);
    }

    public static int convertHorizontalPixelToDpi(int pixel) {
        return Math.round((float)pixel * ScalingHelper.getDpiFactor(Display.getDefault().getDPI().x));
    }

    public static int convertHorizontalDpiToPixel(int dpi) {
        return Math.round((float)dpi / ScalingHelper.getDpiFactor(Display.getDefault().getDPI().x));
    }

    public static int convertVerticalPixelToDpi(int pixel) {
        return Math.round((float)pixel * ScalingHelper.getDpiFactor(Display.getDefault().getDPI().y));
    }

    public static int convertVerticalDpiToPixel(int dpi) {
        return Math.round((float)dpi / ScalingHelper.getDpiFactor(Display.getDefault().getDPI().y));
    }
}

