/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.fordiac.ide.gef.Messages;
import org.eclipse.fordiac.ide.gef.draw2d.ITransparencyFigure;
import org.eclipse.fordiac.ide.gef.draw2d.OverlayAlphaLabel;
import org.eclipse.fordiac.ide.gef.figures.FBShapeShadowBorder;
import org.eclipse.fordiac.ide.gef.listeners.IFontUpdateListener;
import org.eclipse.fordiac.ide.model.edit.providers.TypeImageProvider;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.jface.resource.JFaceResources;

public class FBShape
extends Figure
implements IFontUpdateListener,
ITransparencyFigure {
    private static final String TYPE_TRUNCATION_STRING = "\u2026";
    private static final int INPUT_OUTPUT_INTERLEAVE = 7;
    private static final int FB_NOTCH_INSET = 9;
    private Figure fbFigureContainer;
    private RoundedRectangle top;
    Figure middleContainer;
    private RectangleFigure middle;
    private RoundedRectangle bottom;
    private final Figure eventInputs = new Figure();
    private final Figure eventOutputs = new Figure();
    private final Figure dataInputs = new Figure();
    private final Figure varInOutInputs = new Figure();
    private final Figure sockets = new Figure();
    private final Figure dataOutputs = new Figure();
    private final Figure varInOutOutputs = new Figure();
    private final Figure errorMarkerInput = new Figure();
    private final Figure errorMarkerOutput = new Figure();
    private final Figure pinIndicatorInput = new Figure();
    private final Figure pinIndicatorOutput = new Figure();
    private final Figure plugs = new Figure();
    private OverlayAlphaLabel typeLabel;
    private final int maxTypeLabelSize;

    public FBShape(TypeEntry typeEntry, int maxTypeLabelSize) {
        this.maxTypeLabelSize = maxTypeLabelSize;
        this.configureMainFigure();
        this.createFBFigureShape(typeEntry);
        this.setTypeLabelFont();
        this.setBorder((Border)new FBShapeShadowBorder());
    }

    public Figure getEventInputs() {
        return this.eventInputs;
    }

    public Figure getEventOutputs() {
        return this.eventOutputs;
    }

    public Figure getDataInputs() {
        return this.dataInputs;
    }

    public Figure getVarInOutInputs() {
        return this.varInOutInputs;
    }

    public Figure getSockets() {
        return this.sockets;
    }

    public Figure getDataOutputs() {
        return this.dataOutputs;
    }

    public Figure getVarInOutOutputs() {
        return this.varInOutOutputs;
    }

    public Figure getErrorMarkerInput() {
        return this.errorMarkerInput;
    }

    public Figure getErrorMarkerOutput() {
        return this.errorMarkerOutput;
    }

    public Figure getPinIndicatorInput() {
        return this.pinIndicatorInput;
    }

    public Figure getPinIndicatorOutput() {
        return this.pinIndicatorOutput;
    }

    public Figure getPlugs() {
        return this.plugs;
    }

    public OverlayAlphaLabel getTypeLabel() {
        return this.typeLabel;
    }

    protected RoundedRectangle getTop() {
        return this.top;
    }

    public Shape getMiddle() {
        return this.middle;
    }

    protected RoundedRectangle getBottom() {
        return this.bottom;
    }

    protected final Figure getMiddleContainer() {
        return this.middleContainer;
    }

    public Figure getFbFigureContainer() {
        return this.fbFigureContainer;
    }

    @Override
    public void setTransparency(int value) {
        this.bottom.setAlpha(value);
        this.top.setAlpha(value);
        this.getMiddle().setAlpha(value);
        if (this.getTypeLabel() != null) {
            this.getTypeLabel().setAlpha(value);
        }
    }

    @Override
    public int getTransparency() {
        return this.bottom.getAlpha();
    }

    @Override
    public void updateFonts() {
        this.setTypeLabelFont();
        this.invalidateTree();
        this.revalidate();
    }

    private void setTypeLabelFont() {
        this.typeLabel.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.fordiac.ide.preferences.diagramFontDefinition"));
    }

    private void configureMainFigure() {
        this.setOpaque(false);
        GridLayout mainLayout = new GridLayout(1, true);
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainLayout.horizontalSpacing = 0;
        mainLayout.verticalSpacing = -1;
        this.setLayoutManager((LayoutManager)mainLayout);
    }

    private void createFBFigureShape(TypeEntry typeEntry) {
        this.createFigureContainer();
        this.createFBTop(6);
        this.configureFBMiddle(typeEntry);
        this.createFBBottom(6);
    }

    private void createFBBottom(int cornerDim) {
        this.bottom = new RoundedRectangle();
        this.bottom.setOutline(false);
        this.bottom.setCornerDimensions(new Dimension(cornerDim, cornerDim));
        this.bottom.setLayoutManager((LayoutManager)FBShape.createTopBottomLayout());
        this.addBottom();
        this.setBottomIOs();
        this.setPinIndicators();
    }

    private void setPinIndicators() {
        this.pinIndicatorInput.setLayoutManager((LayoutManager)FBShape.createPinIndicatorLayout());
        this.errorMarkerInput.add((IFigure)this.pinIndicatorInput);
        this.pinIndicatorOutput.setLayoutManager((LayoutManager)FBShape.createPinIndicatorLayout());
        this.errorMarkerOutput.add((IFigure)this.pinIndicatorOutput);
    }

    private static ToolbarLayout createPinIndicatorLayout() {
        ToolbarLayout layout = new ToolbarLayout(false);
        layout.setMinorAlignment(2);
        return layout;
    }

    protected void addBottom() {
        this.fbFigureContainer.add((IFigure)this.bottom, (Object)FBShape.createTopBottomLayoutData(), -1);
    }

    protected void configureFBMiddle(TypeEntry typeEntry) {
        this.middleContainer = new Figure();
        this.middleContainer.setLayoutManager((LayoutManager)new BorderLayout());
        this.middleContainer.setBorder((Border)new MarginBorder(0, 9, 0, 9));
        this.addMiddle();
        this.setupTypeNameAndVersion(typeEntry, this.middleContainer);
    }

    protected void addMiddle() {
        this.fbFigureContainer.add((IFigure)this.middleContainer, (Object)FBShape.createMiddleLayoutData(), -1);
    }

    protected static GridData createMiddleLayoutData() {
        return new GridData(768);
    }

    private void createFBTop(int cornerDim) {
        this.top = new RoundedRectangle();
        this.top.setOutline(false);
        this.top.setCornerDimensions(new Dimension(cornerDim, cornerDim));
        this.top.setLayoutManager((LayoutManager)FBShape.createTopBottomLayout());
        this.addTop();
        this.setupTopIOs();
    }

    protected void addTop() {
        this.fbFigureContainer.add((IFigure)this.top, (Object)FBShape.createTopBottomLayoutData(), -1);
    }

    protected static GridData createTopBottomLayoutData() {
        GridData gridData = new GridData(1808);
        gridData.verticalAlignment = 128;
        return gridData;
    }

    private static GridLayout createTopBottomLayout() {
        GridLayout topLayout = new GridLayout(2, false);
        topLayout.marginHeight = 1;
        topLayout.marginWidth = 0;
        topLayout.verticalSpacing = 0;
        topLayout.horizontalSpacing = 7;
        return topLayout;
    }

    private void createFigureContainer() {
        this.fbFigureContainer = new Figure(){

            public Insets getInsets() {
                return NO_INSETS;
            }
        };
        this.add((IFigure)this.fbFigureContainer);
        this.setConstraint((IFigure)this.fbFigureContainer, FBShape.createDefaultFBContainerLayoutData());
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = -1;
        this.fbFigureContainer.setLayoutManager((LayoutManager)gridLayout);
    }

    protected static GridData createDefaultFBContainerLayoutData() {
        return new GridData(64);
    }

    private void setupTopIOs() {
        this.eventInputs.setLayoutManager((LayoutManager)FBShape.createInputContainerLayout());
        this.eventOutputs.setLayoutManager((LayoutManager)FBShape.createOutputContainerLayout());
        this.addTopIOs();
    }

    protected void addTopIOs() {
        this.top.add((IFigure)this.eventInputs, (Object)FBShape.createInputLayoutData(), -1);
        this.top.add((IFigure)this.eventOutputs, (Object)FBShape.createOutputLayoutData(), -1);
    }

    private void setBottomIOs() {
        this.dataInputs.setLayoutManager((LayoutManager)FBShape.createInputContainerLayout());
        this.dataOutputs.setLayoutManager((LayoutManager)FBShape.createOutputContainerLayout());
        this.varInOutInputs.setLayoutManager((LayoutManager)FBShape.createInputContainerLayout());
        this.varInOutOutputs.setLayoutManager((LayoutManager)FBShape.createOutputContainerLayout());
        this.sockets.setLayoutManager((LayoutManager)FBShape.createInputContainerLayout());
        this.plugs.setLayoutManager((LayoutManager)FBShape.createOutputContainerLayout());
        this.errorMarkerInput.setLayoutManager((LayoutManager)FBShape.createInputContainerLayout());
        this.errorMarkerOutput.setLayoutManager((LayoutManager)FBShape.createOutputContainerLayout());
        this.addBottomIOs();
    }

    private static ToolbarLayout createInputContainerLayout() {
        ToolbarLayout toolbarLayout = new ToolbarLayout(false);
        toolbarLayout.setStretchMinorAxis(true);
        return toolbarLayout;
    }

    private static ToolbarLayout createOutputContainerLayout() {
        ToolbarLayout layout = new ToolbarLayout(false);
        layout.setStretchMinorAxis(true);
        layout.setMinorAlignment(2);
        return layout;
    }

    protected void addBottomIOs() {
        this.bottom.add((IFigure)this.dataInputs, (Object)FBShape.createInputLayoutData(), -1);
        this.bottom.add((IFigure)this.dataOutputs, (Object)FBShape.createOutputLayoutData(), -1);
        this.bottom.add((IFigure)this.varInOutInputs, (Object)FBShape.createInputLayoutData(), -1);
        this.bottom.add((IFigure)this.varInOutOutputs, (Object)FBShape.createOutputLayoutData(), -1);
        this.bottom.add((IFigure)this.sockets, (Object)FBShape.createInputLayoutData(), -1);
        this.bottom.add((IFigure)this.plugs, (Object)FBShape.createOutputLayoutData(), -1);
        this.bottom.add((IFigure)this.errorMarkerInput, (Object)FBShape.createInputLayoutData(), -1);
        this.bottom.add((IFigure)this.errorMarkerOutput, (Object)FBShape.createOutputLayoutData(), -1);
    }

    protected static GridData createInputLayoutData() {
        return new GridData(1, 128, true, false);
    }

    protected static GridData createOutputLayoutData() {
        return new GridData(0x1000008, 128, true, false);
    }

    protected void setupTypeNameAndVersion(TypeEntry typeEntry, Figure container) {
        this.middle = new RectangleFigure();
        this.middle.setOutline(false);
        container.add((IFigure)this.middle, (Object)BorderLayout.CENTER);
        GridLayout middleLayout = new GridLayout(1, true);
        middleLayout.marginHeight = 0;
        middleLayout.verticalSpacing = 0;
        middleLayout.marginWidth = 3;
        this.middle.setLayoutManager((LayoutManager)middleLayout);
        this.typeLabel = new OverlayAlphaLabel();
        this.changeTypeLabelText(typeEntry != null ? typeEntry.getTypeName() : Messages.FBFigure_TYPE_NOT_SET);
        this.typeLabel.setTextAlignment(2);
        this.typeLabel.setOpaque(true);
        this.typeLabel.setIcon(typeEntry != null ? TypeImageProvider.getImageForTypeEntry((TypeEntry)typeEntry) : null);
        this.typeLabel.setIconTextGap(2);
        this.middle.add((IFigure)this.typeLabel);
        this.middle.setConstraint((IFigure)this.typeLabel, (Object)new GridData(768));
    }

    protected void changeTypeLabelText(String text) {
        if (((String)text).length() > this.maxTypeLabelSize) {
            text = ((String)text).substring(0, this.maxTypeLabelSize) + TYPE_TRUNCATION_STRING;
        }
        this.typeLabel.setText((String)text);
    }
}

