/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.application.editparts.TargetInterfaceElementEditPart;
import org.eclipse.fordiac.ide.application.handlers.GotoParentHandler;
import org.eclipse.fordiac.ide.application.widgets.OppositeSelectionDialog;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.model.helpers.FBEndpointFinder;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.CFBInstance;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.HiddenElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.MemberVarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.UntypedSubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.ui.editors.HandlerHelper;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class FollowConnectionHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        return null;
    }

    protected static FBNetwork getFBNetwork(IEditorPart editor) {
        FBNetwork network = (FBNetwork)editor.getAdapter(FBNetwork.class);
        if (network == null) {
            FBNetworkElement element = (FBNetworkElement)editor.getAdapter(FBNetworkElement.class);
            if (element instanceof SubApp) {
                SubApp subApp = (SubApp)element;
                return subApp.getSubAppNetwork();
            }
            if (element instanceof CFBInstance) {
                CFBInstance cfbInstance = (CFBInstance)element;
                return cfbInstance.getCfbNetwork();
            }
        }
        return network;
    }

    public void setEnabled(Object evaluationContext) {
        IStructuredSelection structSel;
        ISelection selection = (ISelection)HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        IEditorPart editor = (IEditorPart)HandlerUtil.getVariable((Object)evaluationContext, (String)"activeEditor");
        if (selection instanceof IStructuredSelection && (structSel = (IStructuredSelection)selection).size() == 1) {
            this.setBaseEnabled(editor != null && this.isValidSelectedElement(structSel));
        } else {
            this.setBaseEnabled(false);
        }
    }

    protected boolean isValidSelectedElement(IStructuredSelection structSel) {
        return structSel.getFirstElement() instanceof InterfaceEditPart;
    }

    protected List<IInterfaceElement> getNextFollowPins(IInterfaceElement pin, boolean stepMode, boolean goRight) {
        if (stepMode) {
            return this.getConnectionOpposites(pin);
        }
        ArrayList<IInterfaceElement> newOpposites = new ArrayList<IInterfaceElement>();
        this.followConnections((List<IInterfaceElement>)newOpposites, goRight, (List<Connection>)this.getConnectionList(pin));
        return newOpposites;
    }

    protected List<IInterfaceElement> getConnectionOpposites(IInterfaceElement ie) {
        EList<Connection> connList = this.getConnectionList(ie);
        return connList.stream().map(con -> con.getSource().equals(ie) ? con.getDestination() : con.getSource()).toList();
    }

    protected abstract EList<Connection> getConnectionList(IInterfaceElement var1);

    protected static boolean isInsideSubappOrViewer(IInterfaceElement ie, FBNetwork fbNetwork) {
        BlockFBNetworkElement fbnElement = ie.getBlockFBNetworkElement();
        return (fbnElement instanceof SubApp || fbnElement instanceof CFBInstance) && !fbNetwork.equals(fbnElement.eContainer());
    }

    private static void showOppositeSelectionDialog(List<IInterfaceElement> opposites, ExecutionEvent event, GraphicalViewer viewer, IInterfaceElement originPin, IEditorPart editor) {
        FollowConnectionHandler.selectInterfaceElement(opposites.getFirst(), editor);
        viewer.flush();
        StructuredSelection selection = (StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IFigure figure = ((InterfaceEditPart)selection.getFirstElement()).getFigure();
        OppositeSelectionDialog dialog = new OppositeSelectionDialog(opposites, originPin, viewer.getControl(), figure, editor);
        dialog.open();
    }

    protected IInterfaceElement getInternalOppositePin(InterfaceEditPart pin) {
        if (this.hasOpposites(pin)) {
            if (pin.isEvent()) {
                return this.getInternalOppositeEventPin(pin);
            }
            if (pin.isVariable()) {
                if (((VarDeclaration)pin.getModel()).isInOutVar()) {
                    return this.getInternalOppositeVarInOutPin(pin);
                }
                return this.getInternalOppositeVarPin(pin);
            }
            return this.getInternalOppositePlugOrSocketPin(pin);
        }
        return null;
    }

    protected abstract IInterfaceElement getInternalOppositeEventPin(InterfaceEditPart var1);

    protected abstract IInterfaceElement getInternalOppositeVarPin(InterfaceEditPart var1);

    protected abstract IInterfaceElement getInternalOppositeVarInOutPin(InterfaceEditPart var1);

    protected abstract IInterfaceElement getInternalOppositePlugOrSocketPin(InterfaceEditPart var1);

    protected boolean hasOpposites(InterfaceEditPart pin) {
        return false;
    }

    protected static void selectOpposites(ExecutionEvent event, GraphicalViewer viewer, IInterfaceElement originPin, List<IInterfaceElement> opposites, IEditorPart editor) {
        if (!opposites.isEmpty()) {
            if (opposites.size() == 1) {
                FollowConnectionHandler.selectInterfaceElement(opposites.getFirst(), editor);
            } else {
                FollowConnectionHandler.showOppositeSelectionDialog(opposites, event, viewer, originPin, editor);
            }
        }
    }

    protected static IInterfaceElement calcInternalOppositePin(EList<? extends IInterfaceElement> source, EList<? extends IInterfaceElement> destination, InterfaceEditPart pin) {
        int sourceIndex = source.stream().filter(HiddenElement::isVisible).toList().indexOf(pin.getModel());
        List<IInterfaceElement> visibleDestinations = destination.stream().filter(HiddenElement::isVisible).toList();
        if (sourceIndex == -1) {
            return visibleDestinations.getFirst();
        }
        if (visibleDestinations.size() - 1 < sourceIndex) {
            return visibleDestinations.get(visibleDestinations.size() - 1);
        }
        return visibleDestinations.get(sourceIndex);
    }

    protected static void gotoParent(ExecutionEvent event) throws ExecutionException {
        GotoParentHandler gotoParentHandler = new GotoParentHandler();
        gotoParentHandler.execute(event);
    }

    protected static boolean isEditorBorderPin(IInterfaceElement ie, FBNetwork fbNetwork) {
        BlockFBNetworkElement fbnElement = ie.getBlockFBNetworkElement();
        FBNetwork containedNetwork = null;
        if (fbnElement instanceof SubApp) {
            SubApp subapp = (SubApp)fbnElement;
            containedNetwork = subapp.getSubAppNetwork();
        } else if (fbnElement instanceof CFBInstance) {
            CFBInstance cfb = (CFBInstance)fbnElement;
            containedNetwork = cfb.getCfbNetwork();
        }
        return containedNetwork != null && containedNetwork.equals(fbNetwork);
    }

    protected static boolean isExpandedSubappPin(IInterfaceElement pin) {
        SubApp subapp;
        BlockFBNetworkElement blockFBNetworkElement = pin.getBlockFBNetworkElement();
        return blockFBNetworkElement instanceof SubApp && (subapp = (SubApp)blockFBNetworkElement).isUnfolded();
    }

    public static void selectInterfaceElement(IInterfaceElement element, IEditorPart editor) {
        GraphicalViewer currentViewer = HandlerHelper.getViewer((IEditorPart)editor);
        if (!HandlerHelper.selectElement((Object)element, (GraphicalViewer)currentViewer)) {
            TargetInterfaceElementEditPart.openInBreadCrumb(element);
        }
    }

    public List<IInterfaceElement> jumpOverStruct(MemberVarDeclaration startPin, boolean goRight) {
        HashSet structEndpoints = new HashSet();
        FBEndpointFinder.traceMembers((MemberVarDeclaration)startPin, structEndpoints);
        ArrayList<IInterfaceElement> opposites = new ArrayList<IInterfaceElement>();
        for (IInterfaceElement endpoint : structEndpoints) {
            List<IInterfaceElement> nextPins = this.getNextFollowPins(endpoint, false, goRight);
            if (nextPins.isEmpty()) {
                opposites.add(endpoint);
                continue;
            }
            opposites.addAll(nextPins);
        }
        return opposites;
    }

    /*
     * WARNING - void declaration
     */
    public void jumpOverConnections(IInterfaceElement startPin, List<IInterfaceElement> destinations, boolean goRight) {
        if (FollowConnectionHandler.isValidPin(startPin, goRight)) {
            destinations.add(startPin);
            return;
        }
        EList<Connection> connections = this.getConnectionList(startPin);
        if (connections.isEmpty()) {
            void memberDeclaration;
            if (!(startPin instanceof MemberVarDeclaration)) {
                destinations.add(startPin);
                return;
            }
            MemberVarDeclaration memberVarDeclaration = (MemberVarDeclaration)startPin;
            HashSet memberEnd = new HashSet();
            FBEndpointFinder.traceMembers((MemberVarDeclaration)memberDeclaration, memberEnd);
            memberEnd.forEach(member -> {
                EList<Connection> cons = this.getConnectionList((IInterfaceElement)member);
                if (cons.isEmpty()) {
                    destinations.add((IInterfaceElement)member);
                } else {
                    this.jumpOverConnections((IInterfaceElement)member, destinations, goRight);
                }
            });
            return;
        }
        this.followConnections(destinations, goRight, (List<Connection>)connections);
    }

    private static boolean isValidPin(IInterfaceElement startPin, boolean goRight) {
        if (startPin instanceof MemberVarDeclaration) {
            return false;
        }
        if (startPin.getBlockFBNetworkElement() instanceof UntypedSubApp) {
            return false;
        }
        return startPin.isIsInput() == goRight;
    }

    private void followConnections(List<IInterfaceElement> destinations, boolean goRight, List<Connection> connections) {
        for (Connection conn : connections) {
            IInterfaceElement next;
            IInterfaceElement iInterfaceElement = next = goRight ? conn.getDestination() : conn.getSource();
            if (conn.isVisible() && next.isIsInput() == goRight) {
                destinations.add(next);
                continue;
            }
            this.jumpOverConnections(next, destinations, goRight);
        }
    }
}

