/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.internal.extension.impl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import org.eclipse.emf.compare.rcp.internal.extension.IItemDescriptor;

public abstract class AbstractItemDescriptor<T>
implements IItemDescriptor<T> {
    protected static final String EMPTY_STRING = "";
    private final String label;
    private final String description;
    private final int rank;
    private final String id;

    public AbstractItemDescriptor(String label, String description, int rank, String id) {
        Preconditions.checkNotNull((Object)id);
        this.label = label != null ? label : id;
        this.description = description != null ? description : EMPTY_STRING;
        this.rank = rank;
        this.id = id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int getRank() {
        return this.rank;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public int compareTo(IItemDescriptor<T> o) {
        Preconditions.checkNotNull(o);
        int comp = o.getRank() - this.getRank();
        if (comp == 0) {
            comp = this.getID().compareTo(o.getID());
        }
        return comp;
    }

    public static <T> Function<IItemDescriptor<T>, T> getItemFunction() {
        return new Function<IItemDescriptor<T>, T>(){

            public T apply(IItemDescriptor<T> input) {
                if (input != null) {
                    return input.getItem();
                }
                return null;
            }
        };
    }

    public String toString() {
        return "StaticItemDescriptor [Label=" + this.getLabel() + ", Description=" + this.getDescription() + ", rank=" + this.getRank() + ", id=" + this.getID() + "]";
    }
}

