/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editparts;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.application.editparts.InterfaceEditPartForFBNetwork;
import org.eclipse.fordiac.ide.application.figures.ConnectionTooltipFigure;
import org.eclipse.fordiac.ide.application.figures.FBNetworkConnection;
import org.eclipse.fordiac.ide.application.figures.FBNetworkConnectionLabel;
import org.eclipse.fordiac.ide.application.policies.DeleteConnectionEditPolicy;
import org.eclipse.fordiac.ide.application.policies.FBNConnectionEndpointPolicy;
import org.eclipse.fordiac.ide.application.tools.ConnectionSelectEditPartTracker;
import org.eclipse.fordiac.ide.application.widgets.OppositeSelectionDialog;
import org.eclipse.fordiac.ide.gef.annotation.AnnotableGraphicalEditPart;
import org.eclipse.fordiac.ide.gef.annotation.FordiacAnnotationUtil;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModelEvent;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationStyles;
import org.eclipse.fordiac.ide.gef.router.BendpointPolicyRouter;
import org.eclipse.fordiac.ide.model.data.AnyBitType;
import org.eclipse.fordiac.ide.model.data.AnyIntType;
import org.eclipse.fordiac.ide.model.data.AnyRealType;
import org.eclipse.fordiac.ide.model.data.AnyStringType;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.datatype.helper.InternalAttributeDeclarations;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterConnection;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.DataConnection;
import org.eclipse.fordiac.ide.model.libraryElement.EventConnection;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.ui.editors.HandlerHelper;
import org.eclipse.fordiac.ide.ui.preferences.PreferenceGetter;
import org.eclipse.fordiac.ide.ui.preferences.UIPreferenceConstants;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.PlatformUI;

public class ConnectionEditPart
extends AbstractConnectionEditPart
implements AnnotableGraphicalEditPart {
    private static final float[] BROKEN_CONNECTION_DASH_PATTERN = new float[]{5.0f, 5.0f};
    private final IPropertyChangeListener propertyChangeListener = event -> {
        if (event.getProperty().equals("EventConnectionConnectorColor") && this.getModel() instanceof EventConnection) {
            this.getFigure().setForegroundColor(PreferenceGetter.getColor((String)"EventConnectionConnectorColor"));
        }
        if (event.getProperty().equals("AdapterConnectionConnectorColor") && this.getModel() instanceof AdapterConnection) {
            this.getFigure().setForegroundColor(PreferenceGetter.getColor((String)"AdapterConnectionConnectorColor"));
        }
        if (UIPreferenceConstants.isDataConnectorProperty((String)event.getProperty()) && this.getModel() instanceof DataConnection) {
            this.getFigure().setForegroundColor(this.getDataConnectioncolor());
        }
        if (event.getProperty().equals("hideDataConnections") && this.getModel() instanceof DataConnection) {
            this.getFigure().setVisible((Boolean)event.getNewValue() == false);
        }
        if (event.getProperty().equals("hideEventConnections") && this.getModel() instanceof EventConnection) {
            this.getFigure().setVisible((Boolean)event.getNewValue() == false);
        }
        if (event.getProperty().equals("MaxHiddenConnectionLabelSize")) {
            this.getFigure().updateConLabels();
        }
    };
    private Adapter contentAdapter;
    private final Adapter srcPinAdapter = new SrcDstAdapter();
    private final Adapter srcFBAdapter = new SrcDstAdapter();
    private final Adapter dstPinAdapter = new SrcDstAdapter();
    private final Adapter dstFBAdapter = new SrcDstAdapter();

    private static void updateConnectionLables(List<?> editPartConnections) {
        editPartConnections.stream().filter(ConnectionEditPart.class::isInstance).map(ConnectionEditPart.class::cast).map(ConnectionEditPart::getFigure).forEach(FBNetworkConnection::updateConLabels);
    }

    private EditPart getTargetEP() {
        return this.getTarget();
    }

    public Connection getModel() {
        return (Connection)super.getModel();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new FBNConnectionEndpointPolicy());
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new DeleteConnectionEditPolicy());
        this.installEditPolicy("Connection Bendpoint Policy", ((BendpointPolicyRouter)this.getConnectionFigure().getConnectionRouter()).getBendpointPolicy((Object)this.getModel()));
    }

    protected IFigure createFigure() {
        FBNetworkConnection connectionFigure = new FBNetworkConnection(this);
        this.setConnectionColor((PolylineConnection)connectionFigure);
        connectionFigure.setHidden(!this.getModel().isVisible());
        this.performConnTypeConfiguration(connectionFigure);
        connectionFigure.setToolTip((IFigure)new ConnectionTooltipFigure(this.getModel(), FordiacAnnotationUtil.getAnnotationModel((EditPart)this)));
        connectionFigure.setLineWidth(2);
        return connectionFigure;
    }

    private void performConnTypeConfiguration(FBNetworkConnection connectionFigure) {
        if (this.getModel() instanceof EventConnection) {
            connectionFigure.setVisible(!UIPreferenceConstants.STORE.getBoolean("hideEventConnections"));
        }
        if (this.getModel() instanceof DataConnection) {
            connectionFigure.setVisible(!UIPreferenceConstants.STORE.getBoolean("hideDataConnections"));
        }
    }

    public FBNetworkConnection getFigure() {
        return (FBNetworkConnection)super.getFigure();
    }

    public FBNetworkConnection getConnectionFigure() {
        return (FBNetworkConnection)super.getConnectionFigure();
    }

    private void setConnectionColor(PolylineConnection connection) {
        if (this.getModel() instanceof EventConnection) {
            connection.setForegroundColor(PreferenceGetter.getColor((String)"EventConnectionConnectorColor"));
        }
        if (this.getModel() instanceof AdapterConnection) {
            connection.setForegroundColor(PreferenceGetter.getColor((String)"AdapterConnectionConnectorColor"));
        }
        if (this.getModel() instanceof DataConnection) {
            connection.setForegroundColor(this.getDataConnectioncolor());
        }
    }

    private Color getDataConnectioncolor() {
        DataType dataType;
        IInterfaceElement refElement = this.getModel().getSource();
        if (refElement == null) {
            refElement = this.getModel().getDestination();
        }
        if (refElement != null && !ConnectionEditPart.isColoredDataype(dataType = refElement.getType()) && refElement == this.getModel().getSource()) {
            refElement = this.getModel().getDestination();
        }
        if (refElement != null) {
            return PreferenceGetter.getDataColor((String)refElement.getType().getName());
        }
        return PreferenceGetter.getDefaultDataColor();
    }

    private static boolean isColoredDataype(DataType dataType) {
        return dataType == IecTypes.ElementaryTypes.BOOL || dataType instanceof AnyBitType || dataType instanceof AnyIntType || dataType instanceof AnyRealType || dataType instanceof AnyStringType || dataType instanceof StructuredType;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        if (this.getModel() != null) {
            if (this.getModel().isBrokenConnection()) {
                this.getConnectionFigure().setLineStyle(6);
                this.getConnectionFigure().setLineDash(BROKEN_CONNECTION_DASH_PATTERN);
            } else {
                this.getConnectionFigure().setLineStyle(1);
                this.getConnectionFigure().setLineDash(null);
            }
            this.getConnectionFigure().setHidden(!this.getModel().isVisible());
            this.getConnectionFigure().updateConLabels();
            this.getConnectionFigure().revalidate();
        }
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            UIPreferenceConstants.STORE.addPropertyChangeListener(this.propertyChangeListener);
            this.getModel().eAdapters().add((Object)this.getContentAdapter());
            this.addSourceAdapters();
            this.addDestinationAdapters();
        }
    }

    public void performRequest(Request request) {
        if (request.getType() == "open" && request instanceof SelectionRequest) {
            SelectionRequest selReq = (SelectionRequest)request;
            if (ConnectionEditPart.isDecoratorTargeted(selReq.getLocation(), this.getFigure().getSourceDecoration())) {
                IInterfaceElement sourcePin = this.getModel().getSource();
                if (sourcePin.getOutputConnections().size() > 1) {
                    this.followMultipleTargetConnections(sourcePin, sourcePin.getOutputConnections().stream().map(Connection::getDestination).toList());
                } else {
                    this.followConnection(this.getTargetEP());
                }
            }
            if (ConnectionEditPart.isDecoratorTargeted(selReq.getLocation(), this.getFigure().getTargetDecoration())) {
                IInterfaceElement destPin = this.getModel().getDestination();
                if (destPin.getInputConnections().size() > 1) {
                    this.followMultipleTargetConnections(destPin, destPin.getInputConnections().stream().map(Connection::getSource).toList());
                } else {
                    this.followConnection(this.getSource());
                }
            }
        }
        super.performRequest(request);
    }

    private void followMultipleTargetConnections(IInterfaceElement originPin, List<IInterfaceElement> targetList) {
        GraphicalViewer viewer = (GraphicalViewer)this.getViewer();
        GraphicalEditPart firstTargetEP = (GraphicalEditPart)viewer.getEditPartForModel((Object)targetList.getFirst());
        HandlerHelper.selectEditPart((EditPartViewer)viewer, (EditPart)firstTargetEP);
        viewer.flush();
        OppositeSelectionDialog dialog = new OppositeSelectionDialog(targetList, originPin, viewer.getControl(), firstTargetEP.getFigure(), PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor());
        dialog.open();
    }

    private void followConnection(EditPart targetEP) {
        EditPartViewer viewer = this.getViewer();
        HandlerHelper.selectEditPart((EditPartViewer)viewer, (EditPart)targetEP);
    }

    private static boolean isDecoratorTargeted(Point location, FBNetworkConnectionLabel decoration) {
        if (decoration != null) {
            location = location.getCopy();
            decoration.translateToRelative((Translatable)location);
            return decoration.getBounds().contains(location);
        }
        return false;
    }

    private void addDestinationAdapters() {
        if (this.getModel().getDestination() != null && this.dstPinAdapter.getTarget() == null) {
            this.getModel().getDestination().eAdapters().add((Object)this.dstPinAdapter);
            if (this.getModel().getDestinationElement() != null) {
                this.getModel().getDestinationElement().eAdapters().add((Object)this.dstFBAdapter);
            }
        }
    }

    private void addSourceAdapters() {
        if (this.getModel().getSource() != null && this.srcPinAdapter.getTarget() == null) {
            this.getModel().getSource().eAdapters().add((Object)this.srcPinAdapter);
            if (this.getModel().getSourceElement() != null) {
                this.getModel().getSourceElement().eAdapters().add((Object)this.srcFBAdapter);
            }
        }
    }

    private Adapter getContentAdapter() {
        if (this.contentAdapter == null) {
            this.contentAdapter = new ConnectionContentAdapter();
        }
        return this.contentAdapter;
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            UIPreferenceConstants.STORE.removePropertyChangeListener(this.propertyChangeListener);
            this.getModel().eAdapters().remove((Object)this.getContentAdapter());
            if (this.srcPinAdapter.getTarget() != null) {
                this.srcPinAdapter.getTarget().eAdapters().remove((Object)this.srcPinAdapter);
            }
            if (this.srcFBAdapter.getTarget() != null) {
                this.srcFBAdapter.getTarget().eAdapters().remove((Object)this.srcFBAdapter);
            }
            if (this.dstPinAdapter.getTarget() != null) {
                this.dstPinAdapter.getTarget().eAdapters().remove((Object)this.dstPinAdapter);
            }
            if (this.dstFBAdapter.getTarget() != null) {
                this.dstFBAdapter.getTarget().eAdapters().remove((Object)this.dstFBAdapter);
            }
        }
    }

    public void setTransparency(int value) {
        FBNetworkConnection connection = this.getFigure();
        connection.setAlpha(value);
        for (Object fig : connection.getChildren()) {
            if (!(fig instanceof Shape)) continue;
            Shape shape = (Shape)fig;
            shape.setAlpha(value);
        }
    }

    public DragTracker getDragTracker(Request req) {
        return new ConnectionSelectEditPartTracker(this);
    }

    public boolean isSelectionShown() {
        return this.getConnectionEndPointPolicy().isSelectionFeedbackShowing();
    }

    private FBNConnectionEndpointPolicy getConnectionEndPointPolicy() {
        return (FBNConnectionEndpointPolicy)this.getEditPolicy("Connection Endpoint Policy");
    }

    public void updateAnnotations(GraphicalAnnotationModelEvent event) {
        GraphicalAnnotationStyles.updateAnnotationFeedback((IFigure)this.getFigure(), (Object)this.getModel(), (GraphicalAnnotationModelEvent)event);
        this.refreshTooltip();
    }

    private void refreshTooltip() {
        this.getFigure().setToolTip((IFigure)new ConnectionTooltipFigure(this.getModel(), FordiacAnnotationUtil.getAnnotationModel((EditPart)this)));
    }

    private class ConnectionContentAdapter
    extends EContentAdapter {
        private ConnectionContentAdapter() {
        }

        public void notifyChanged(Notification notification) {
            Object feature = notification.getFeature();
            ConnectionEditPart.this.refreshVisuals();
            if (LibraryElementPackage.eINSTANCE.getINamedElement_Comment().equals(feature) || LibraryElementPackage.eINSTANCE.getConnection_Destination().equals(feature) || LibraryElementPackage.eINSTANCE.getConnection_Source().equals(feature)) {
                ConnectionEditPart.this.refreshTooltip();
            }
            if (LibraryElementPackage.eINSTANCE.getConnection_Source().equals(feature)) {
                ConnectionEditPart.this.addSourceAdapters();
            }
            if (LibraryElementPackage.eINSTANCE.getConnection_Destination().equals(feature)) {
                ConnectionEditPart.this.addDestinationAdapters();
                ConnectionEditPart.this.setConnectionColor((PolylineConnection)ConnectionEditPart.this.getFigure());
                ConnectionEditPart.this.getFigure().setLineWidth(2);
            }
            if (LibraryElementPackage.eINSTANCE.getConfigurableObject_Attributes().equals(feature)) {
                this.handleVisibilityUpdate();
            }
            if (LibraryElementPackage.eINSTANCE.getDataConnection_FBNetwork().equals(feature) || LibraryElementPackage.eINSTANCE.getEventConnection_FBNetwork().equals(feature) || LibraryElementPackage.eINSTANCE.getAdapterConnection_FBNetwork().equals(feature)) {
                ConnectionEditPart.this.getFigure().handleVisibilityChange(!ConnectionEditPart.this.getModel().isVisible());
            }
        }

        private void handleVisibilityUpdate() {
            ConnectionEditPart.this.getModel().getSource().eNotify((Notification)new ENotificationImpl((InternalEObject)ConnectionEditPart.this.getModel().getSource(), 1, (EStructuralFeature)LibraryElementPackage.eINSTANCE.getIInterfaceElement_OutputConnections(), (Object)ConnectionEditPart.this.getModel(), (Object)ConnectionEditPart.this.getModel()));
            ConnectionEditPart.this.getModel().getDestination().eNotify((Notification)new ENotificationImpl((InternalEObject)ConnectionEditPart.this.getModel().getDestination(), 1, (EStructuralFeature)LibraryElementPackage.eINSTANCE.getIInterfaceElement_InputConnections(), (Object)ConnectionEditPart.this.getModel(), (Object)ConnectionEditPart.this.getModel()));
            FBNConnectionEndpointPolicy conEPPolicy = ConnectionEditPart.this.getConnectionEndPointPolicy();
            if (conEPPolicy.isSelectionFeedbackShowing()) {
                conEPPolicy.hideSelection();
                conEPPolicy.showSelection();
            }
        }
    }

    private final class SrcDstAdapter
    extends AdapterImpl {
        private SrcDstAdapter() {
        }

        public void notifyChanged(Notification notification) {
            Object feature = notification.getFeature();
            if (LibraryElementPackage.eINSTANCE.getINamedElement_Name().equals(feature) || LibraryElementPackage.eINSTANCE.getIInterfaceElement_InputConnections().equals(feature) || LibraryElementPackage.eINSTANCE.getIInterfaceElement_OutputConnections().equals(feature) || LibraryElementPackage.eINSTANCE.getINamedElement_Comment().equals(feature) || LibraryElementPackage.eINSTANCE.getFBNetworkElement_Group().equals(feature)) {
                InterfaceEditPartForFBNetwork editPart;
                EditPart editPart2;
                InterfaceEditPartForFBNetwork editPart3;
                EditPart editPart4 = ConnectionEditPart.this.getSource();
                if (editPart4 instanceof InterfaceEditPartForFBNetwork && !(editPart3 = (InterfaceEditPartForFBNetwork)editPart4).getModel().isIsInput()) {
                    ConnectionEditPart.updateConnectionLables(editPart3.getSourceConnections());
                }
                if ((editPart2 = ConnectionEditPart.this.getTargetEP()) instanceof InterfaceEditPartForFBNetwork && (editPart = (InterfaceEditPartForFBNetwork)editPart2).getModel().isIsInput()) {
                    ConnectionEditPart.updateConnectionLables(editPart.getTargetConnections());
                }
            }
            if (LibraryElementPackage.eINSTANCE.getFBNetworkElement_Group().equals(feature) || LibraryElementPackage.eINSTANCE.getConfigurableObject_Attributes().equals(notification.getFeature()) && this.unfoldedStateChanged(notification)) {
                ConnectionEditPart.this.getFigure().handleVisibilityChange(ConnectionEditPart.this.getFigure().isHidden());
            }
        }

        private boolean unfoldedStateChanged(Notification notification) {
            Attribute attribute;
            Attribute attribute2;
            Object object = notification.getNewValue();
            if (object instanceof Attribute && (attribute2 = (Attribute)object).getAttributeDeclaration() == InternalAttributeDeclarations.UNFOLDED) {
                return true;
            }
            Object object2 = notification.getOldValue();
            return object2 instanceof Attribute && (attribute = (Attribute)object2).getAttributeDeclaration() == InternalAttributeDeclarations.UNFOLDED;
        }
    }
}

