/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.commands;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerInterface;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.gef.commands.Command;

public class CreateNewTypeLibraryEntryCommand
extends Command {
    private final TypeLibrary typeLib;
    private final TypeEntry oldTypeEntry;
    private List<ErrorMarkerInterface> interfaces;
    private IFile newTypeEntryFile;
    private TypeEntry newTypeEntry;

    public CreateNewTypeLibraryEntryCommand(TypeLibrary typeLib, TypeEntry entry) {
        this.typeLib = typeLib;
        this.oldTypeEntry = entry;
    }

    public CreateNewTypeLibraryEntryCommand(TypeLibrary typeLib, TypeEntry entry, List<ErrorMarkerInterface> interfaces) {
        this(typeLib, entry);
        this.interfaces = interfaces;
    }

    public void execute() {
        LibraryElement newType = (LibraryElement)EcoreUtil.copy((EObject)this.oldTypeEntry.getType());
        this.newTypeEntryFile = this.getTargetTypeFile(newType);
        this.newTypeEntry = this.typeLib.createTypeEntry(this.newTypeEntryFile);
        CreateNewTypeLibraryEntryCommand.addNetwork(newType);
        if (this.interfaces != null) {
            CreateNewTypeLibraryEntryCommand.addConnections(newType, this.interfaces);
        }
        try {
            this.newTypeEntry.save(newType);
        }
        catch (CoreException e) {
            FordiacLogHelper.logError((String)e.getMessage());
        }
    }

    private static void addConnections(LibraryElement newType, List<ErrorMarkerInterface> markers) {
        InterfaceList interfaceList;
        if (newType instanceof FBType) {
            FBType fbType = (FBType)newType;
            interfaceList = fbType.getInterfaceList();
        } else {
            interfaceList = LibraryElementFactory.eINSTANCE.createInterfaceList();
        }
        InterfaceList interfaceList2 = interfaceList;
        for (ErrorMarkerInterface errorMarkerInterface : markers) {
        }
        ((FBType)newType).setInterfaceList(interfaceList2);
    }

    private static void addNetwork(LibraryElement type) {
        if (type instanceof CompositeFBType) {
            CompositeFBType compositeType = (CompositeFBType)type;
            FBNetwork network = LibraryElementFactory.eINSTANCE.createFBNetwork();
            compositeType.setFBNetwork(network);
        }
    }

    private IFile getTargetTypeFile(LibraryElement element) {
        String typeEnding = null;
        if (element instanceof SubAppType) {
            typeEnding = ".SUB";
        } else if (element instanceof AdapterType) {
            typeEnding = ".ADP";
        } else if (element instanceof BaseFBType || element instanceof CompositeFBType) {
            typeEnding = ".FBT";
        }
        Path path = new Path(String.valueOf(this.typeLib.getProject()) + File.separator + element.getName() + typeEnding);
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
    }

    public void undo() {
        this.typeLib.removeTypeEntry(this.newTypeEntry);
    }

    public void redo() {
        this.newTypeEntry = this.typeLib.createTypeEntry(this.newTypeEntryFile);
    }
}

