/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.fordiac.ide.deployment.DeploymentCoordinator;
import org.eclipse.fordiac.ide.deployment.IDeploymentExecutor;
import org.eclipse.fordiac.ide.deployment.exceptions.DisconnectException;
import org.eclipse.fordiac.ide.deployment.util.IDeploymentListener;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractDeploymentCommand
extends AbstractHandler {
    protected Device device = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Object[] list = this.getObjectArrayFromSelection(selection);
        if (list != null) {
            Object[] objectArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                Object currentElement = objectArray[n2];
                if (this.prepareParametersToExecute(currentElement)) {
                    IDeploymentExecutor executor = DeploymentCoordinator.getInstance().getDeploymentExecutor(this.device);
                    if (executor != null) {
                        block16: {
                            String mgrid = DeploymentCoordinator.getMGR_ID((Device)this.device);
                            DeploymentCoordinator.getInstance().enableOutput(executor.getDevMgmComHandler());
                            OnlineDeploymentErrorCheckListener.getInstance().setCurrentObject(this);
                            OnlineDeploymentErrorCheckListener.getInstance().setLastMessage("");
                            OnlineDeploymentErrorCheckListener.getInstance().setLastCommand("");
                            executor.getDevMgmComHandler().addDeploymentListener((IDeploymentListener)OnlineDeploymentErrorCheckListener.getInstance());
                            try {
                                try {
                                    executor.getDevMgmComHandler().connect(mgrid);
                                    this.executeCommand(executor);
                                }
                                catch (Exception e) {
                                    OnlineDeploymentErrorCheckListener.getInstance().showDeploymentError(e.getMessage(), mgrid, this, true);
                                    try {
                                        executor.getDevMgmComHandler().disconnect();
                                    }
                                    catch (DisconnectException e2) {
                                        OnlineDeploymentErrorCheckListener.getInstance().showDeploymentError(e2.getMessage(), mgrid, this, true);
                                    }
                                    break block16;
                                }
                            }
                            catch (Throwable throwable) {
                                try {
                                    executor.getDevMgmComHandler().disconnect();
                                }
                                catch (DisconnectException e) {
                                    OnlineDeploymentErrorCheckListener.getInstance().showDeploymentError(e.getMessage(), mgrid, this, true);
                                }
                                throw throwable;
                            }
                            try {
                                executor.getDevMgmComHandler().disconnect();
                            }
                            catch (DisconnectException e) {
                                OnlineDeploymentErrorCheckListener.getInstance().showDeploymentError(e.getMessage(), mgrid, this, true);
                            }
                        }
                        executor.getDevMgmComHandler().removeDeploymentListener((IDeploymentListener)OnlineDeploymentErrorCheckListener.getInstance());
                        DeploymentCoordinator.getInstance().flush();
                        DeploymentCoordinator.getInstance().disableOutput(executor.getDevMgmComHandler());
                    } else {
                        this.manageExecutorError();
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    protected Object[] getObjectArrayFromSelection(ISelection selection) {
        Object[] list = null;
        if (selection instanceof StructuredSelection) {
            list = ((StructuredSelection)selection).toArray();
        }
        return list;
    }

    protected abstract boolean prepareParametersToExecute(Object var1);

    protected abstract void executeCommand(IDeploymentExecutor var1) throws Exception;

    protected void manageExecutorError() {
        DeploymentCoordinator.printUnsupportedDeviceProfileMessageBox((Device)this.device, null);
    }

    protected abstract String getErrorMessageHeader();

    protected abstract String getCurrentElementName();

    public static class OnlineDeploymentErrorCheckListener
    implements IDeploymentListener {
        private AbstractDeploymentCommand currentObject = null;
        private String lastMessage = "";
        private String lastCommand = "";
        private static OnlineDeploymentErrorCheckListener instance = null;

        public void setLastMessage(String lastMessage) {
            this.lastMessage = lastMessage;
        }

        public void setCurrentObject(AbstractDeploymentCommand currentObject) {
            this.currentObject = currentObject;
        }

        public void setLastCommand(String lastCommand) {
            this.lastCommand = lastCommand;
        }

        public void postCommandSent(String command, String destination) {
            this.lastCommand = command;
        }

        public void postCommandSent(String message) {
            this.lastCommand = message;
        }

        public void responseReceived(String response, String source) {
            if (response.contains("Reason")) {
                this.showDeploymentError(response.substring(response.lastIndexOf("Reason") + 8, response.length() - 4), source, this.currentObject, false);
            }
        }

        public void finished() {
        }

        public void postCommandSent(String info, String destination, String command) {
            this.lastCommand = command;
        }

        public static OnlineDeploymentErrorCheckListener getInstance() {
            if (instance == null) {
                instance = new OnlineDeploymentErrorCheckListener();
            }
            return instance;
        }

        public void showDeploymentError(String response, String source, AbstractDeploymentCommand currentElement, boolean showWithConsole) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IViewPart view = page.findView("org.eclipse.fordiac.ide.deployment.ui.views.Output");
            String currentMessage = !this.lastCommand.equals("") ? String.valueOf(currentElement.getCurrentElementName()) + "\n" + "Request: " + this.lastCommand + "\nProblem: " + response + "\nSource: " + source + "\nCheck the Deplopyment Console for more information" : String.valueOf(currentElement.getCurrentElementName()) + "\n" + "Problem: " + response + "\nSource: " + source;
            if ((view == null || showWithConsole) && !this.lastMessage.equals(currentMessage)) {
                Shell shell = Display.getDefault().getActiveShell();
                MessageDialog.openError((Shell)shell, (String)currentElement.getErrorMessageHeader(), (String)currentMessage);
                this.lastMessage = currentMessage;
            }
        }
    }
}

